/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.utils.JcrUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/hosts")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class HostController {
    private static final Logger LOG = LoggerFactory.getLogger(HostController.class);
    private final RepositoryService repositoryService;

    @Autowired
    public HostController(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @GET
    @Path(value="/")
    public String treeForHost() throws JSONException {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Host.class));
        List<Host> allHosts = this.repositoryService.listEntities(query);
        if (allHosts == null) {
            allHosts = Collections.emptyList();
        }
        query = new SearchParameters().setType(Type.valueOf(BaseTestSpecification.class));
        List allTestSpecifications = this.repositoryService.listEntities(query);
        return this.createHostTree(allHosts, allTestSpecifications).toString();
    }

    @POST
    @Path(value="/")
    public Response create(BaseConfigurationItem item) {
        String name = Synthetic.retrieveFullNameFromNotEncodedHostId(item.getId());
        String encodedId = Synthetic.createHostId(name);
        item.setId(encodedId);
        this.repositoryService.create((ConfigurationItem[])new BaseConfigurationItem[]{item});
        item.setId(Synthetic.createNotEncodedHostId(name));
        return Response.status((int)201).entity((Object)item).build();
    }

    @PUT
    @Path(value="/{hostName:.+}")
    public Response update(@PathParam(value="hostName") String hostName, BaseConfigurationItem item) {
        String originalIdFromItem = item.getId();
        if (!item.getName().equals(hostName)) {
            String encodedOriginalid = Synthetic.createHostId(hostName);
            String name = Synthetic.retrieveFullNameFromNotEncodedHostId(item.getId());
            String encodedIdToMoveTo = Synthetic.createHostId(name);
            item.setId(encodedIdToMoveTo);
            this.repositoryService.move(encodedOriginalid, encodedIdToMoveTo);
        }
        this.repositoryService.update((ConfigurationItem[])new BaseConfigurationItem[]{item});
        item.setId(originalIdFromItem);
        return Response.status((int)200).entity((Object)item).build();
    }

    @GET
    @Path(value="/{hostName:.+}")
    public Response get(@PathParam(value="hostName") String hostName) {
        ConfigurationItem item = this.repositoryService.read(Synthetic.createHostId(hostName));
        item.setId(JcrUtils.decodeJcrId(item.getId()));
        return Response.status((int)200).entity((Object)item).build();
    }

    @DELETE
    @Path(value="/{hostName:.+}")
    public void deleteHost(@PathParam(value="hostName") String hostName) {
        LOG.info("removing host: {}", (Object)hostName);
        this.repositoryService.delete(new String[]{Synthetic.createHostId(hostName)});
        LOG.info("removed host: {}", (Object)hostName);
    }

    protected JSONArray createHostTree(List<Host> allHosts, List<BaseTestSpecification> allTestSpecifications) throws JSONException {
        JSONArray jArray = new JSONArray();
        for (Host host : allHosts) {
            JSONObject child = new JSONObject();
            child.put("name", (Object)JcrUtils.decodeJcrId(host.getName()));
            child.put("type", (Object)host.getType());
            List<BaseTestSpecification> testSpecificationsUsingHost = this.getTestSpecificationsUsingHost(host.getId(), allTestSpecifications);
            if (testSpecificationsUsingHost != null) {
                child.put("testSpecifications", (Object)this.createTestSpecificationList(testSpecificationsUsingHost));
            }
            jArray.put((Object)child);
        }
        return jArray;
    }

    protected JSONArray createTestSpecificationList(List<BaseTestSpecification> testSpecifications) throws JSONException {
        JSONArray jArray = new JSONArray();
        for (BaseTestSpecification testSpecification : testSpecifications) {
            JSONObject child = new JSONObject();
            child.put("name", (Object)JcrUtils.decodeJcrId(testSpecification.getName()));
            child.put("title", (Object)testSpecification.getTitle());
            child.put("type", (Object)testSpecification.getType());
            jArray.put((Object)child);
        }
        return jArray;
    }

    private List<BaseTestSpecification> getTestSpecificationsUsingHost(String hostId, List<BaseTestSpecification> allTestSpecifications) {
        ArrayList<BaseTestSpecification> testSpecifications = new ArrayList<BaseTestSpecification>();
        for (BaseTestSpecification testSpecification : allTestSpecifications) {
            if (!testSpecification.hasProperty("host") || testSpecification.getProperty("host") == null || !((Host)testSpecification.getProperty("host")).getId().equals(hostId)) continue;
            testSpecifications.add(testSpecification);
        }
        return testSpecifications;
    }
}

