/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.base.Joiner;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryModule;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositoryNameModule;
import org.elasticsearch.repositories.RepositoryTypesRegistry;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.VerificationFailure;
import org.elasticsearch.repositories.VerifyNodeRepositoryAction;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.transport.TransportService;

public class RepositoriesService
extends AbstractComponent
implements ClusterStateListener {
    private final RepositoryTypesRegistry typesRegistry;
    private final Injector injector;
    private final ClusterService clusterService;
    private final VerifyNodeRepositoryAction verifyAction;
    private volatile ImmutableMap<String, RepositoryHolder> repositories = ImmutableMap.of();

    @Inject
    public RepositoriesService(Settings settings, ClusterService clusterService, TransportService transportService, RepositoryTypesRegistry typesRegistry, Injector injector) {
        super(settings);
        this.typesRegistry = typesRegistry;
        this.injector = injector;
        this.clusterService = clusterService;
        if (DiscoveryNode.dataNode(settings) || DiscoveryNode.masterNode(settings)) {
            clusterService.add(this);
        }
        this.verifyAction = new VerifyNodeRepositoryAction(settings, transportService, clusterService, this);
    }

    public void registerRepository(final RegisterRepositoryRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        final RepositoryMetaData newRepositoryMetaData = new RepositoryMetaData(request.name, request.type, request.settings);
        VerifyingRegisterRepositoryListener registrationListener = request.verify ? new VerifyingRegisterRepositoryListener(request.name, listener) : listener;
        this.clusterService.submitStateUpdateTask(request.cause, new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>((AckedRequest)request, (ActionListener)registrationListener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws IOException {
                RepositoriesService.this.ensureRepositoryNotInUse(currentState, request.name);
                if (!RepositoriesService.this.registerRepository(newRepositoryMetaData)) {
                    return currentState;
                }
                MetaData metaData = currentState.metaData();
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                RepositoriesMetaData repositories = (RepositoriesMetaData)metaData.custom("repositories");
                if (repositories == null) {
                    RepositoriesService.this.logger.info("put repository [{}]", request.name);
                    repositories = new RepositoriesMetaData(new RepositoryMetaData(request.name, request.type, request.settings));
                } else {
                    boolean found = false;
                    ArrayList<RepositoryMetaData> repositoriesMetaData = new ArrayList<RepositoryMetaData>(repositories.repositories().size() + 1);
                    for (RepositoryMetaData repositoryMetaData : repositories.repositories()) {
                        if (repositoryMetaData.name().equals(newRepositoryMetaData.name())) {
                            found = true;
                            repositoriesMetaData.add(newRepositoryMetaData);
                            continue;
                        }
                        repositoriesMetaData.add(repositoryMetaData);
                    }
                    if (!found) {
                        RepositoriesService.this.logger.info("put repository [{}]", request.name);
                        repositoriesMetaData.add(new RepositoryMetaData(request.name, request.type, request.settings));
                    } else {
                        RepositoriesService.this.logger.info("update repository [{}]", request.name);
                    }
                    repositories = new RepositoriesMetaData(repositoriesMetaData.toArray(new RepositoryMetaData[repositoriesMetaData.size()]));
                }
                mdBuilder.putCustom("repositories", repositories);
                return ClusterState.builder(currentState).metaData(mdBuilder).build();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                RepositoriesService.this.logger.warn("failed to create repository [{}]", t, request.name);
                super.onFailure(source, t);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return discoveryNode.masterNode();
            }
        });
    }

    public void unregisterRepository(final UnregisterRepositoryRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask(request.cause, new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>((AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesService.this.ensureRepositoryNotInUse(currentState, request.name);
                MetaData metaData = currentState.metaData();
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                RepositoriesMetaData repositories = (RepositoriesMetaData)metaData.custom("repositories");
                if (repositories != null && repositories.repositories().size() > 0) {
                    ArrayList<RepositoryMetaData> repositoriesMetaData = new ArrayList<RepositoryMetaData>(repositories.repositories().size());
                    boolean changed = false;
                    for (RepositoryMetaData repositoryMetaData : repositories.repositories()) {
                        if (Regex.simpleMatch(request.name, repositoryMetaData.name())) {
                            RepositoriesService.this.logger.info("delete repository [{}]", repositoryMetaData.name());
                            changed = true;
                            continue;
                        }
                        repositoriesMetaData.add(repositoryMetaData);
                    }
                    if (changed) {
                        repositories = new RepositoriesMetaData(repositoriesMetaData.toArray(new RepositoryMetaData[repositoriesMetaData.size()]));
                        mdBuilder.putCustom("repositories", repositories);
                        return ClusterState.builder(currentState).metaData(mdBuilder).build();
                    }
                }
                throw new RepositoryMissingException(request.name);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return discoveryNode.masterNode();
            }
        });
    }

    public void verifyRepository(final String repositoryName, final ActionListener<VerifyResponse> listener) {
        block7: {
            final Repository repository = this.repository(repositoryName);
            try {
                final String verificationToken = repository.startVerification();
                if (verificationToken != null) {
                    try {
                        this.verifyAction.verify(repositoryName, verificationToken, new ActionListener<VerifyResponse>(){

                            @Override
                            public void onResponse(VerifyResponse verifyResponse) {
                                try {
                                    repository.endVerification(verificationToken);
                                }
                                catch (Throwable t) {
                                    RepositoriesService.this.logger.warn("[{}] failed to finish repository verification", repositoryName, t);
                                    listener.onFailure(t);
                                    return;
                                }
                                listener.onResponse(verifyResponse);
                            }

                            @Override
                            public void onFailure(Throwable e) {
                                listener.onFailure(e);
                            }
                        });
                    }
                    catch (Throwable t) {
                        try {
                            repository.endVerification(verificationToken);
                        }
                        catch (Throwable t1) {
                            this.logger.warn("[{}] failed to finish repository verification", repositoryName, t);
                        }
                        listener.onFailure(t);
                    }
                    break block7;
                }
                listener.onResponse(new VerifyResponse(new DiscoveryNode[0], new VerificationFailure[0]));
            }
            catch (Throwable t) {
                listener.onFailure(t);
            }
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            RepositoriesMetaData oldMetaData = (RepositoriesMetaData)event.previousState().getMetaData().custom("repositories");
            RepositoriesMetaData newMetaData = (RepositoriesMetaData)event.state().getMetaData().custom("repositories");
            if (oldMetaData == null && newMetaData == null || oldMetaData != null && oldMetaData.equals(newMetaData)) {
                return;
            }
            this.logger.trace("processing new index repositories for state version [{}]", event.state().version());
            HashMap survivors = Maps.newHashMap();
            for (Map.Entry entry : this.repositories.entrySet()) {
                if (newMetaData == null || newMetaData.repository((String)entry.getKey()) == null) {
                    this.logger.debug("unregistering repository [{}]", entry.getKey());
                    this.closeRepository((String)entry.getKey(), (RepositoryHolder)entry.getValue());
                    continue;
                }
                survivors.put(entry.getKey(), entry.getValue());
            }
            ImmutableMap.Builder<String, RepositoryHolder> builder = ImmutableMap.builder();
            if (newMetaData != null) {
                for (RepositoryMetaData repositoryMetaData : newMetaData.repositories()) {
                    RepositoryHolder holder = (RepositoryHolder)survivors.get(repositoryMetaData.name());
                    if (holder != null) {
                        if (!holder.type.equals(repositoryMetaData.type()) || !holder.settings.equals(repositoryMetaData.settings())) {
                            this.logger.debug("updating repository [{}]", repositoryMetaData.name());
                            this.closeRepository(repositoryMetaData.name(), holder);
                            holder = this.createRepositoryHolder(repositoryMetaData);
                        }
                    } else {
                        holder = this.createRepositoryHolder(repositoryMetaData);
                    }
                    if (holder == null) continue;
                    this.logger.debug("registering repository [{}]", repositoryMetaData.name());
                    builder.put(repositoryMetaData.name(), holder);
                }
            }
            this.repositories = builder.build();
        }
        catch (Throwable ex) {
            this.logger.warn("failure updating cluster state ", ex, new Object[0]);
        }
    }

    public Repository repository(String repository) {
        RepositoryHolder holder = this.repositories.get(repository);
        if (holder != null) {
            return holder.repository;
        }
        throw new RepositoryMissingException(repository);
    }

    public IndexShardRepository indexShardRepository(String repository) {
        RepositoryHolder holder = this.repositories.get(repository);
        if (holder != null) {
            return holder.indexShardRepository;
        }
        throw new RepositoryMissingException(repository);
    }

    private boolean registerRepository(RepositoryMetaData repositoryMetaData) throws IOException {
        RepositoryHolder previous = this.repositories.get(repositoryMetaData.name());
        if (previous != null && !previous.type.equals(repositoryMetaData.type()) && previous.settings.equals(repositoryMetaData.settings())) {
            return false;
        }
        RepositoryHolder holder = this.createRepositoryHolder(repositoryMetaData);
        if (previous != null) {
            this.closeRepository(repositoryMetaData.name(), previous);
        }
        HashMap<String, RepositoryHolder> newRepositories = Maps.newHashMap(this.repositories);
        newRepositories.put(repositoryMetaData.name(), holder);
        this.repositories = ImmutableMap.copyOf(newRepositories);
        return true;
    }

    private void closeRepository(String name, RepositoryHolder holder) throws IOException {
        this.logger.debug("closing repository [{}][{}]", holder.type, name);
        if (holder.repository != null) {
            holder.repository.close();
        }
    }

    private RepositoryHolder createRepositoryHolder(RepositoryMetaData repositoryMetaData) {
        this.logger.debug("creating repository [{}][{}]", repositoryMetaData.type(), repositoryMetaData.name());
        Injector repositoryInjector = null;
        try {
            ModulesBuilder modules = new ModulesBuilder();
            RepositoryName name = new RepositoryName(repositoryMetaData.type(), repositoryMetaData.name());
            modules.add((Module)new RepositoryNameModule(name));
            modules.add((Module)new RepositoryModule(name, repositoryMetaData.settings(), this.settings, this.typesRegistry));
            repositoryInjector = modules.createChildInjector(this.injector);
            Repository repository = repositoryInjector.getInstance(Repository.class);
            IndexShardRepository indexShardRepository = repositoryInjector.getInstance(IndexShardRepository.class);
            repository.start();
            return new RepositoryHolder(repositoryMetaData.type(), repositoryMetaData.settings(), repositoryInjector, repository, indexShardRepository);
        }
        catch (Throwable t) {
            this.logger.warn("failed to create repository [{}][{}]", t, repositoryMetaData.type(), repositoryMetaData.name());
            throw new RepositoryException(repositoryMetaData.name(), "failed to create repository", t);
        }
    }

    private void ensureRepositoryNotInUse(ClusterState clusterState, String repository) {
        if (SnapshotsService.isRepositoryInUse(clusterState, repository) || RestoreService.isRepositoryInUse(clusterState, repository)) {
            throw new ElasticsearchIllegalStateException("trying to modify or unregister repository that is currently used ");
        }
    }

    public static class VerifyResponse {
        private VerificationFailure[] failures;
        private DiscoveryNode[] nodes;

        public VerifyResponse(DiscoveryNode[] nodes, VerificationFailure[] failures) {
            this.nodes = nodes;
            this.failures = failures;
        }

        public VerificationFailure[] failures() {
            return this.failures;
        }

        public DiscoveryNode[] nodes() {
            return this.nodes;
        }

        public boolean failed() {
            return this.failures.length > 0;
        }

        public String failureDescription() {
            StringBuilder builder = new StringBuilder(91);
            Joiner.on(", ").appendTo(builder, (Object[])this.failures);
            return builder.append(']').toString();
        }
    }

    public static class UnregisterRepositoryRequest
    extends ClusterStateUpdateRequest<UnregisterRepositoryRequest> {
        final String cause;
        final String name;

        public UnregisterRepositoryRequest(String cause, String name) {
            this.cause = cause;
            this.name = name;
        }
    }

    public static class RegisterRepositoryRequest
    extends ClusterStateUpdateRequest<RegisterRepositoryRequest> {
        final String cause;
        final String name;
        final String type;
        final boolean verify;
        Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;

        public RegisterRepositoryRequest(String cause, String name, String type, boolean verify) {
            this.cause = cause;
            this.name = name;
            this.type = type;
            this.verify = verify;
        }

        public RegisterRepositoryRequest settings(Settings settings) {
            this.settings = settings;
            return this;
        }
    }

    private static class RepositoryHolder {
        private final String type;
        private final Settings settings;
        private final Repository repository;
        private final IndexShardRepository indexShardRepository;

        public RepositoryHolder(String type, Settings settings, Injector injector, Repository repository, IndexShardRepository indexShardRepository) {
            this.type = type;
            this.settings = settings;
            this.repository = repository;
            this.indexShardRepository = indexShardRepository;
        }
    }

    private class VerifyingRegisterRepositoryListener
    implements ActionListener<ClusterStateUpdateResponse> {
        private final String name;
        private final ActionListener<ClusterStateUpdateResponse> listener;

        public VerifyingRegisterRepositoryListener(String name, ActionListener<ClusterStateUpdateResponse> listener) {
            this.name = name;
            this.listener = listener;
        }

        @Override
        public void onResponse(final ClusterStateUpdateResponse clusterStateUpdateResponse) {
            if (clusterStateUpdateResponse.isAcknowledged()) {
                RepositoriesService.this.verifyRepository(this.name, new ActionListener<VerifyResponse>(){

                    @Override
                    public void onResponse(VerifyResponse verifyResponse) {
                        if (verifyResponse.failed()) {
                            VerifyingRegisterRepositoryListener.this.listener.onFailure(new RepositoryVerificationException(VerifyingRegisterRepositoryListener.this.name, verifyResponse.failureDescription()));
                        } else {
                            VerifyingRegisterRepositoryListener.this.listener.onResponse(clusterStateUpdateResponse);
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        VerifyingRegisterRepositoryListener.this.listener.onFailure(e);
                    }
                });
            } else {
                this.listener.onResponse(clusterStateUpdateResponse);
            }
        }

        @Override
        public void onFailure(Throwable e) {
            this.listener.onFailure(e);
        }
    }
}

