/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.http.client.HttpDownloadHelper;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.internal.InternalSettingsPreparer;

public class PluginManager {
    public static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueMillis(0L);
    private static final ImmutableSet<Object> BLACKLIST = ((ImmutableSet.Builder)ImmutableSet.builder().add(new Object[]{"elasticsearch", "elasticsearch.bat", "elasticsearch.in.sh", "plugin", "plugin.bat", "service.bat"})).build();
    private static final ImmutableSet<Object> VALID_TOP_LEVEL_PLUGIN_DIRS = ((ImmutableSet.Builder)ImmutableSet.builder().add(new Object[]{"_site", "bin", "config", "_dict"})).build();
    private final Environment environment;
    private String url;
    private OutputMode outputMode;
    private TimeValue timeout;
    private static final int EXIT_CODE_OK = 0;
    private static final int EXIT_CODE_CMD_USAGE = 64;
    private static final int EXIT_CODE_IO_ERROR = 74;
    private static final int EXIT_CODE_ERROR = 70;

    public PluginManager(Environment environment, String url, OutputMode outputMode, TimeValue timeout) {
        this.environment = environment;
        this.url = url;
        this.outputMode = outputMode;
        this.timeout = timeout;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAndExtract(String name) throws IOException {
        File configFile;
        if (name == null) {
            throw new ElasticsearchIllegalArgumentException("plugin name must be supplied with --install [name].");
        }
        HttpDownloadHelper downloadHelper = new HttpDownloadHelper();
        boolean downloaded = false;
        HttpDownloadHelper.DownloadProgress progress = this.outputMode == OutputMode.SILENT ? new HttpDownloadHelper.NullProgress() : new HttpDownloadHelper.VerboseProgress(System.out);
        if (!this.environment.pluginsFile().canWrite()) {
            System.err.println();
            throw new IOException("plugin directory " + this.environment.pluginsFile() + " is read only");
        }
        PluginHandle pluginHandle = PluginHandle.parse(name);
        PluginManager.checkForForbiddenName(pluginHandle.name);
        File pluginFile = pluginHandle.distroFile(this.environment);
        File extractLocation = pluginHandle.extractedDir(this.environment);
        if (extractLocation.exists()) {
            throw new IOException("plugin directory " + extractLocation.getAbsolutePath() + " already exists. To update the plugin, uninstall it first using --remove " + name + " command");
        }
        if (this.url != null) {
            URL pluginUrl = new URL(this.url);
            this.log("Trying " + pluginUrl.toExternalForm() + "...");
            try {
                downloadHelper.download(pluginUrl, pluginFile, progress, this.timeout);
                downloaded = true;
            }
            catch (ElasticsearchTimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                this.log("Failed: " + ExceptionsHelper.detailedMessage(e));
            }
        }
        if (!downloaded) {
            for (URL url : pluginHandle.urls()) {
                this.log("Trying " + url.toExternalForm() + "...");
                try {
                    downloadHelper.download(url, pluginFile, progress, this.timeout);
                    downloaded = true;
                    break;
                }
                catch (ElasticsearchTimeoutException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.debug("Failed: " + ExceptionsHelper.detailedMessage(e));
                }
            }
        }
        if (!downloaded) {
            throw new IOException("failed to download out of all possible locations..., use --verbose to get detailed information");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(pluginFile);
            boolean removeTopLevelDir = this.topLevelDirInExcess(zipFile);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) continue;
                String zipEntryName = zipEntry.getName().replace('\\', '/');
                if (removeTopLevelDir) {
                    zipEntryName = zipEntryName.substring(zipEntryName.indexOf(47));
                }
                File target = new File(extractLocation, zipEntryName);
                FileSystemUtils.mkdirs(target.getParentFile());
                Streams.copy(zipFile.getInputStream(zipEntry), (OutputStream)new FileOutputStream(target));
            }
            this.log("Installed " + name + " into " + extractLocation.getAbsolutePath());
        }
        catch (Exception e) {
            this.log("failed to extract plugin [" + pluginFile + "]: " + ExceptionsHelper.detailedMessage(e));
            return;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
            pluginFile.delete();
        }
        if (FileSystemUtils.hasExtensions(extractLocation, ".java")) {
            this.debug("Plugin installation assumed to be site plugin, but contains source code, aborting installation...");
            FileSystemUtils.deleteRecursively(extractLocation);
            throw new IllegalArgumentException("Plugin installation assumed to be site plugin, but contains source code, aborting installation.");
        }
        boolean potentialSitePlugin = true;
        File binFile = new File(extractLocation, "bin");
        if (binFile.isDirectory()) {
            File toLocation = pluginHandle.binDir(this.environment);
            this.debug("Found bin, moving to " + toLocation.getAbsolutePath());
            FileSystemUtils.deleteRecursively(toLocation);
            try {
                FileSystemUtils.move(binFile.toPath(), toLocation.toPath());
            }
            catch (IOException e) {
                throw new IOException("Could not move [" + binFile + "] to [" + toLocation + "]", e);
            }
            Files.walkFileTree(toLocation.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isRegularFile()) {
                        file.toFile().setExecutable(true);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            this.debug("Installed " + name + " into " + toLocation.getAbsolutePath());
            potentialSitePlugin = false;
        }
        if ((configFile = new File(extractLocation, "config")).isDirectory()) {
            File configDestLocation = pluginHandle.configDir(this.environment);
            this.debug("Found config, moving to " + configDestLocation.getAbsolutePath());
            FileSystemUtils.moveFilesWithoutOverwriting(configFile, configDestLocation, ".new");
            this.debug("Installed " + name + " into " + configDestLocation.getAbsolutePath());
            potentialSitePlugin = false;
        }
        if (!new File(extractLocation, "_site").exists() && potentialSitePlugin && !FileSystemUtils.hasExtensions(extractLocation, ".class", ".jar")) {
            this.log("Identified as a _site plugin, moving to _site structure ...");
            File site = new File(extractLocation, "_site");
            File tmpLocation = new File(this.environment.pluginsFile(), extractLocation.getName() + ".tmp");
            if (!extractLocation.renameTo(tmpLocation)) {
                throw new IOException("failed to rename in order to copy to _site (rename to " + tmpLocation.getAbsolutePath() + "");
            }
            FileSystemUtils.mkdirs(extractLocation);
            if (!tmpLocation.renameTo(site)) {
                throw new IOException("failed to rename in order to copy to _site (rename to " + site.getAbsolutePath() + "");
            }
            this.debug("Installed " + name + " into " + site.getAbsolutePath());
        }
    }

    public void removePlugin(String name) throws IOException {
        File binLocation;
        if (name == null) {
            throw new ElasticsearchIllegalArgumentException("plugin name must be supplied with --remove [name].");
        }
        PluginHandle pluginHandle = PluginHandle.parse(name);
        boolean removed = false;
        PluginManager.checkForForbiddenName(pluginHandle.name);
        File pluginToDelete = pluginHandle.extractedDir(this.environment);
        if (pluginToDelete.exists()) {
            this.debug("Removing: " + pluginToDelete.getPath());
            if (!FileSystemUtils.deleteRecursively(pluginToDelete, true)) {
                throw new IOException("Unable to remove " + pluginHandle.name + ". Check file permissions on " + pluginToDelete.toString());
            }
            removed = true;
        }
        if ((pluginToDelete = pluginHandle.distroFile(this.environment)).exists()) {
            this.debug("Removing: " + pluginToDelete.getPath());
            if (!pluginToDelete.delete()) {
                throw new IOException("Unable to remove " + pluginHandle.name + ". Check file permissions on " + pluginToDelete.toString());
            }
            removed = true;
        }
        if ((binLocation = pluginHandle.binDir(this.environment)).exists()) {
            this.debug("Removing: " + binLocation.getPath());
            if (!FileSystemUtils.deleteRecursively(binLocation)) {
                throw new IOException("Unable to remove " + pluginHandle.name + ". Check file permissions on " + binLocation.toString());
            }
            removed = true;
        }
        if (removed) {
            this.log("Removed " + name);
        } else {
            this.log("Plugin " + name + " not found. Run plugin --list to get list of installed plugins.");
        }
    }

    private static void checkForForbiddenName(String name) {
        if (!Strings.hasLength(name) || BLACKLIST.contains(name.toLowerCase(Locale.ROOT))) {
            throw new ElasticsearchIllegalArgumentException("Illegal plugin name: " + name);
        }
    }

    public File[] getListInstalledPlugins() {
        File[] plugins = this.environment.pluginsFile().listFiles();
        return plugins;
    }

    public void listInstalledPlugins() {
        File[] plugins = this.getListInstalledPlugins();
        this.log("Installed plugins:");
        if (plugins == null || plugins.length == 0) {
            this.log("    - No plugin detected in " + this.environment.pluginsFile().getAbsolutePath());
        } else {
            for (int i = 0; i < plugins.length; ++i) {
                this.log("    - " + plugins[i].getName());
            }
        }
    }

    private boolean topLevelDirInExcess(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        HashSet<String> topLevelDirNames = new HashSet<String>();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String zipEntryName = zipEntry.getName().replace('\\', '/');
            int slash = zipEntryName.indexOf(47);
            if (slash == -1) {
                return false;
            }
            topLevelDirNames.add(zipEntryName.substring(0, slash));
            if (topLevelDirNames.size() <= 1) continue;
            return false;
        }
        if (topLevelDirNames.size() == 1) {
            return !VALID_TOP_LEVEL_PLUGIN_DIRS.contains(topLevelDirNames.iterator().next());
        }
        return false;
    }

    public static void main(String[] args) {
        Tuple<Settings, Environment> initialSettings = InternalSettingsPreparer.prepareSettings(ImmutableSettings.Builder.EMPTY_SETTINGS, true);
        if (!initialSettings.v2().pluginsFile().exists()) {
            FileSystemUtils.mkdirs(initialSettings.v2().pluginsFile());
        }
        String url = null;
        OutputMode outputMode = OutputMode.DEFAULT;
        String pluginName = null;
        TimeValue timeout = DEFAULT_TIMEOUT;
        int action = 0;
        if (args.length < 1) {
            PluginManager.displayHelp(null);
        }
        try {
            block56: for (int c = 0; c < args.length; ++c) {
                String command;
                switch (command = args[c]) {
                    case "-u": 
                    case "--url": 
                    case "url": 
                    case "-url": {
                        url = PluginManager.getCommandValue(args, ++c, "--url");
                        action = 1;
                        continue block56;
                    }
                    case "-v": 
                    case "--verbose": 
                    case "verbose": 
                    case "-verbose": {
                        outputMode = OutputMode.VERBOSE;
                        continue block56;
                    }
                    case "-s": 
                    case "--silent": 
                    case "silent": 
                    case "-silent": {
                        outputMode = OutputMode.SILENT;
                        continue block56;
                    }
                    case "-i": 
                    case "--install": 
                    case "install": 
                    case "-install": {
                        pluginName = PluginManager.getCommandValue(args, ++c, "--install");
                        action = 1;
                        continue block56;
                    }
                    case "-r": 
                    case "--remove": 
                    case "remove": 
                    case "-remove": {
                        pluginName = PluginManager.getCommandValue(args, ++c, "--remove");
                        action = 2;
                        continue block56;
                    }
                    case "-t": 
                    case "--timeout": 
                    case "timeout": 
                    case "-timeout": {
                        String timeoutValue = PluginManager.getCommandValue(args, ++c, "--timeout");
                        timeout = TimeValue.parseTimeValue(timeoutValue, DEFAULT_TIMEOUT);
                        continue block56;
                    }
                    case "-l": 
                    case "--list": {
                        action = 3;
                        continue block56;
                    }
                    case "-h": 
                    case "--help": {
                        PluginManager.displayHelp(null);
                        continue block56;
                    }
                    default: {
                        PluginManager.displayHelp("Command [" + command + "] unknown.");
                        System.exit(64);
                    }
                }
            }
        }
        catch (Throwable e) {
            PluginManager.displayHelp("Error while parsing options: " + e.getClass().getSimpleName() + ": " + e.getMessage());
            System.exit(64);
        }
        if (action > 0) {
            int exitCode = 70;
            PluginManager pluginManager = new PluginManager(initialSettings.v2(), url, outputMode, timeout);
            switch (action) {
                case 1: {
                    try {
                        pluginManager.log("-> Installing " + org.elasticsearch.common.base.Strings.nullToEmpty(pluginName) + "...");
                        pluginManager.downloadAndExtract(pluginName);
                        exitCode = 0;
                    }
                    catch (IOException e) {
                        exitCode = 74;
                        pluginManager.log("Failed to install " + pluginName + ", reason: " + e.getMessage());
                    }
                    catch (Throwable e) {
                        exitCode = 70;
                        PluginManager.displayHelp("Error while installing plugin, reason: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    }
                    break;
                }
                case 2: {
                    try {
                        pluginManager.log("-> Removing " + org.elasticsearch.common.base.Strings.nullToEmpty(pluginName) + "...");
                        pluginManager.removePlugin(pluginName);
                        exitCode = 0;
                    }
                    catch (ElasticsearchIllegalArgumentException e) {
                        exitCode = 64;
                        pluginManager.log("Failed to remove " + pluginName + ", reason: " + e.getMessage());
                    }
                    catch (IOException e) {
                        exitCode = 74;
                        pluginManager.log("Failed to remove " + pluginName + ", reason: " + e.getMessage());
                    }
                    catch (Throwable e) {
                        exitCode = 70;
                        PluginManager.displayHelp("Error while removing plugin, reason: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    }
                    break;
                }
                case 3: {
                    try {
                        pluginManager.listInstalledPlugins();
                        exitCode = 0;
                    }
                    catch (Throwable e) {
                        PluginManager.displayHelp("Error while listing plugins, reason: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    }
                    break;
                }
                default: {
                    pluginManager.log("Unknown Action [" + action + "]");
                    exitCode = 70;
                }
            }
            System.exit(exitCode);
        }
    }

    private static String getCommandValue(String[] args, int arg, String flag) {
        if (arg >= args.length) {
            throw new ElasticsearchIllegalStateException("missing value for " + flag + ". Usage: " + flag + " [value]");
        }
        String trimmedValue = org.elasticsearch.common.base.Strings.emptyToNull(args[arg].trim());
        if (trimmedValue == null) {
            throw new ElasticsearchIllegalArgumentException("value for " + flag + "('" + args[arg] + "') must be set. Usage: " + flag + " [value]");
        }
        return trimmedValue;
    }

    private static void displayHelp(String message) {
        System.out.println("Usage:");
        System.out.println("    -u, --url     [plugin location]   : Set exact URL to download the plugin from");
        System.out.println("    -i, --install [plugin name]       : Downloads and installs listed plugins [*]");
        System.out.println("    -t, --timeout [duration]          : Timeout setting: 30s, 1m, 1h... (infinite by default)");
        System.out.println("    -r, --remove  [plugin name]       : Removes listed plugins");
        System.out.println("    -l, --list                        : List installed plugins");
        System.out.println("    -v, --verbose                     : Prints verbose messages");
        System.out.println("    -s, --silent                      : Run in silent mode");
        System.out.println("    -h, --help                        : Prints this help message");
        System.out.println();
        System.out.println(" [*] Plugin name could be:");
        System.out.println("     elasticsearch/plugin/version for official elasticsearch plugins (download from download.elasticsearch.org)");
        System.out.println("     groupId/artifactId/version   for community plugins (download from maven central or oss sonatype)");
        System.out.println("     username/repository          for site plugins (download from github master)");
        if (message != null) {
            System.out.println();
            System.out.println("Message:");
            System.out.println("   " + message);
        }
    }

    private void debug(String line) {
        if (this.outputMode == OutputMode.VERBOSE) {
            System.out.println(line);
        }
    }

    private void log(String line) {
        if (this.outputMode != OutputMode.SILENT) {
            System.out.println(line);
        }
    }

    static class PluginHandle {
        final String name;
        final String version;
        final String user;
        final String repo;

        PluginHandle(String name, String version, String user, String repo) {
            this.name = name;
            this.version = version;
            this.user = user;
            this.repo = repo;
        }

        List<URL> urls() {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (this.version != null) {
                PluginHandle.addUrl(urls, "http://download.elasticsearch.org/" + this.user + "/" + this.repo + "/" + this.repo + "-" + this.version + ".zip");
                PluginHandle.addUrl(urls, "http://search.maven.org/remotecontent?filepath=" + this.user.replace('.', '/') + "/" + this.repo + "/" + this.version + "/" + this.repo + "-" + this.version + ".zip");
                PluginHandle.addUrl(urls, "https://oss.sonatype.org/service/local/repositories/releases/content/" + this.user.replace('.', '/') + "/" + this.repo + "/" + this.version + "/" + this.repo + "-" + this.version + ".zip");
                PluginHandle.addUrl(urls, "https://github.com/" + this.user + "/" + this.repo + "/archive/" + this.version + ".zip");
            }
            PluginHandle.addUrl(urls, "https://github.com/" + this.user + "/" + this.repo + "/archive/master.zip");
            return urls;
        }

        private static void addUrl(List<URL> urls, String url) {
            try {
                urls.add(new URL(url));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        File distroFile(Environment env) {
            return new File(env.pluginsFile(), this.name + ".zip");
        }

        File extractedDir(Environment env) {
            return new File(env.pluginsFile(), this.name);
        }

        File binDir(Environment env) {
            return new File(new File(env.homeFile(), "bin"), this.name);
        }

        File configDir(Environment env) {
            return new File(env.configFile(), this.name);
        }

        static PluginHandle parse(String name) {
            String[] elements = name.split("/");
            String repo = elements[0];
            String user = null;
            String version = null;
            if (elements.length > 1) {
                user = elements[0];
                repo = elements[1];
                if (elements.length > 2) {
                    version = elements[2];
                }
            }
            if (repo.startsWith("elasticsearch-")) {
                String endname = repo.substring("elasticsearch-".length());
                return new PluginHandle(endname, version, user, repo);
            }
            if (name.startsWith("es-")) {
                String endname = repo.substring("es-".length());
                return new PluginHandle(endname, version, user, repo);
            }
            return new PluginHandle(repo, version, user, repo);
        }
    }

    public static enum OutputMode {
        DEFAULT,
        SILENT,
        VERBOSE;

    }

    public static final class ACTION {
        public static final int NONE = 0;
        public static final int INSTALL = 1;
        public static final int REMOVE = 2;
        public static final int LIST = 3;
    }
}

