/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.DirectoryUtils;
import org.elasticsearch.index.store.distributor.Distributor;

public final class DistributorDirectory
extends BaseDirectory {
    private final Distributor distributor;
    private final HashMap<String, Directory> nameDirMapping = new HashMap();

    public DistributorDirectory(final Directory ... dirs) throws IOException {
        this(new Distributor(){
            final AtomicInteger count = new AtomicInteger();

            @Override
            public Directory primary() {
                return dirs[0];
            }

            @Override
            public Directory[] all() {
                return dirs;
            }

            @Override
            public synchronized Directory any() {
                return dirs[MathUtils.mod(this.count.incrementAndGet(), dirs.length)];
            }
        });
    }

    public DistributorDirectory(Distributor distributor) throws IOException {
        this.distributor = distributor;
        for (Directory dir : distributor.all()) {
            for (String file : dir.listAll()) {
                this.nameDirMapping.put(file, dir);
            }
        }
        this.lockFactory = new DistributorLockFactoryWrapper(distributor.primary());
    }

    public final synchronized String[] listAll() throws IOException {
        return this.nameDirMapping.keySet().toArray(new String[this.nameDirMapping.size()]);
    }

    public synchronized boolean fileExists(String name) throws IOException {
        try {
            return this.getDirectory(name).fileExists(name);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    public synchronized void deleteFile(String name) throws IOException {
        this.getDirectory(name, true).deleteFile(name);
        Directory remove = this.nameDirMapping.remove(name);
        assert (remove != null) : "Tried to delete file " + name + " but couldn't";
    }

    public synchronized long fileLength(String name) throws IOException {
        return this.getDirectory(name).fileLength(name);
    }

    public synchronized IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.getDirectory(name, false).createOutput(name, context);
    }

    public void sync(Collection<String> names) throws IOException {
        for (Directory dir : this.distributor.all()) {
            dir.sync(names);
        }
    }

    public synchronized IndexInput openInput(String name, IOContext context) throws IOException {
        return this.getDirectory(name).openInput(name, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            assert (this.assertConsistency());
        }
        finally {
            IOUtils.close((Closeable[])this.distributor.all());
        }
    }

    Directory getDirectory(String name) throws IOException {
        return this.getDirectory(name, true);
    }

    private Directory getDirectory(String name, boolean failIfNotAssociated) throws IOException {
        Directory directory = this.nameDirMapping.get(name);
        if (directory == null) {
            if (failIfNotAssociated) {
                throw new FileNotFoundException("No such file [" + name + "]");
            }
            Directory dir = this.distributor.any();
            assert (!this.nameDirMapping.containsKey(name));
            this.nameDirMapping.put(name, dir);
            return dir;
        }
        return directory;
    }

    public synchronized void setLockFactory(LockFactory lockFactory) throws IOException {
        this.distributor.primary().setLockFactory(lockFactory);
        super.setLockFactory((LockFactory)new DistributorLockFactoryWrapper(this.distributor.primary()));
    }

    public synchronized String getLockID() {
        return this.distributor.primary().getLockID();
    }

    public synchronized String toString() {
        return this.distributor.toString();
    }

    public synchronized void renameFile(DirectoryService directoryService, String source, String dest) throws IOException {
        Directory directory = this.getDirectory(source);
        Directory targetDir = this.nameDirMapping.get(dest);
        if (targetDir != null && targetDir != directory) {
            throw new IOException("Can't rename file from " + source + " to: " + dest + ": target file already exists in a different directory");
        }
        directoryService.renameFile(directory, source, dest);
        this.nameDirMapping.remove(source);
        this.nameDirMapping.put(dest, directory);
    }

    Distributor getDistributor() {
        return this.distributor;
    }

    private synchronized boolean assertConsistency() throws IOException {
        boolean consistent = true;
        try {
            Directory[] all;
            StringBuilder builder = new StringBuilder();
            for (Directory d : all = this.distributor.all()) {
                for (String file : d.listAll()) {
                    Directory directory = this.nameDirMapping.get(file);
                    if (directory == null) {
                        consistent = false;
                        builder.append("File ").append(file).append(" was not mapped to a directory but exists in one of the distributors directories").append(System.lineSeparator());
                        continue;
                    }
                    if (directory == d) continue;
                    consistent = false;
                    builder.append("File ").append(file).append(" was  mapped to a directory ").append(directory).append(" but exists in another distributor directory").append(d).append(System.lineSeparator());
                }
            }
            assert (consistent) : builder.toString();
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {
            // empty catch block
        }
        return consistent;
    }

    private class DistributorLockFactoryWrapper
    extends LockFactory {
        private final Directory dir;
        private final LockFactory delegate;
        private final boolean writesFiles;

        public DistributorLockFactoryWrapper(Directory dir) {
            this.dir = dir;
            FSDirectory leaf = DirectoryUtils.getLeaf(dir, FSDirectory.class);
            this.writesFiles = leaf != null ? leaf.getLockFactory() instanceof FSLockFactory : false;
            this.delegate = dir.getLockFactory();
        }

        public void setLockPrefix(String lockPrefix) {
            this.delegate.setLockPrefix(lockPrefix);
        }

        public String getLockPrefix() {
            return this.delegate.getLockPrefix();
        }

        public Lock makeLock(String lockName) {
            return new DistributorLock(this.delegate.makeLock(lockName), lockName);
        }

        public void clearLock(String lockName) throws IOException {
            this.delegate.clearLock(lockName);
        }

        public String toString() {
            return "DistributorLockFactoryWrapper(" + this.delegate.toString() + ")";
        }

        private class DistributorLock
        extends Lock {
            private final Lock delegateLock;
            private final String name;

            DistributorLock(Lock delegate, String name) {
                this.delegateLock = delegate;
                this.name = name;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean obtain() throws IOException {
                if (this.delegateLock.obtain()) {
                    if (DistributorLockFactoryWrapper.this.writesFiles) {
                        DistributorDirectory distributorDirectory = DistributorDirectory.this;
                        synchronized (distributorDirectory) {
                            assert (!DistributorDirectory.this.nameDirMapping.containsKey(this.name) || DistributorDirectory.this.nameDirMapping.get(this.name) == DistributorLockFactoryWrapper.this.dir);
                            if (DistributorDirectory.this.nameDirMapping.get(this.name) == null) {
                                DistributorDirectory.this.nameDirMapping.put(this.name, DistributorLockFactoryWrapper.this.dir);
                            }
                        }
                    }
                    return true;
                }
                return false;
            }

            public void close() throws IOException {
                this.delegateLock.close();
            }

            public boolean isLocked() throws IOException {
                return this.delegateLock.isLocked();
            }
        }
    }
}

