/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermRangeFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class ExistsFilterParser
implements FilterParser {
    public static final String NAME = "exists";

    @Inject
    public ExistsFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldPattern = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                fieldPattern = parser.text();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[exists] filter does not support [" + currentFieldName + "]");
        }
        if (fieldPattern == null) {
            throw new QueryParsingException(parseContext.index(), "exists must be provided with a [field]");
        }
        return ExistsFilterParser.newFilter(parseContext, fieldPattern, filterName);
    }

    public static Filter newFilter(QueryParseContext parseContext, String fieldPattern, String filterName) {
        List<String> fields;
        FieldMappers fieldNamesMapper = parseContext.mapperService().indexName("_field_names");
        MapperService.SmartNameObjectMapper smartNameObjectMapper = parseContext.smartObjectMapper(fieldPattern);
        if (smartNameObjectMapper != null && smartNameObjectMapper.hasMapper()) {
            fieldPattern = fieldPattern + ".*";
        }
        if ((fields = parseContext.simpleMatchToIndexNames(fieldPattern)).isEmpty()) {
            return Queries.MATCH_NO_FILTER;
        }
        MapperService.SmartNameFieldMappers nonNullFieldMappers = null;
        XBooleanFilter boolFilter = new XBooleanFilter();
        for (String field : fields) {
            MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(field);
            if (smartNameFieldMappers != null) {
                nonNullFieldMappers = smartNameFieldMappers;
            }
            TermRangeFilter filter = null;
            if (fieldNamesMapper != null && fieldNamesMapper.mapper().fieldType().indexed()) {
                String f = smartNameFieldMappers != null && smartNameFieldMappers.hasMapper() ? smartNameFieldMappers.mapper().names().indexName() : field;
                filter = fieldNamesMapper.mapper().termFilter(f, parseContext);
            }
            if (filter == null && smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
                filter = smartNameFieldMappers.mapper().rangeFilter(null, null, true, true, parseContext);
            }
            if (filter == null) {
                filter = new TermRangeFilter(field, null, null, true, true);
            }
            boolFilter.add((Filter)filter, BooleanClause.Occur.SHOULD);
        }
        Filter filter = parseContext.cacheFilter(boolFilter, new CacheKeyFilter.Key("$exists$" + fieldPattern));
        filter = QueryParsers.wrapSmartNameFilter(filter, nonNullFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

