/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineSearcherFactory;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;

public class ShadowEngine
extends Engine {
    private volatile SearcherManager searcherManager;
    private SegmentInfos lastCommittedSegmentInfos;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ShadowEngine(EngineConfig engineConfig) {
        super(engineConfig);
        EngineSearcherFactory searcherFactory = new EngineSearcherFactory(engineConfig);
        try {
            this.store.incRef();
            boolean success = false;
            try {
                this.searcherManager = new SearcherManager(this.store.directory(), (SearcherFactory)searcherFactory);
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                return;
            }
            catch (Throwable e) {
                try {
                    this.logger.warn("failed to create new reader", e, new Object[0]);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.searcherManager});
                    this.store.decRef();
                    throw throwable;
                }
            }
        }
        catch (IOException ex) {
            throw new EngineCreationFailureException(this.shardId, "failed to open index reader", (Throwable)ex);
        }
    }

    @Override
    public void create(Engine.Create create) throws EngineException {
        throw new UnsupportedOperationException(this.shardId + " create operation not allowed on shadow engine");
    }

    @Override
    public void index(Engine.Index index) throws EngineException {
        throw new UnsupportedOperationException(this.shardId + " index operation not allowed on shadow engine");
    }

    @Override
    public void delete(Engine.Delete delete) throws EngineException {
        throw new UnsupportedOperationException(this.shardId + " delete operation not allowed on shadow engine");
    }

    @Override
    public void delete(Engine.DeleteByQuery delete) throws EngineException {
        throw new UnsupportedOperationException(this.shardId + " delete-by-query operation not allowed on shadow engine");
    }

    @Override
    public void flush() throws EngineException {
        this.flush(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean force, boolean waitIfOngoing) throws EngineException {
        this.logger.trace("skipping FLUSH on shadow engine", new Object[0]);
        this.refresh("flush");
        this.store.incRef();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
        }
        catch (Throwable e) {
            if (!this.isClosed.get()) {
                this.logger.warn("failed to read latest segment infos on flush", e, new Object[0]);
                if (Lucene.isCorruptionException(e)) {
                    throw new FlushFailedEngineException(this.shardId, e);
                }
            }
        }
        finally {
            this.store.decRef();
        }
    }

    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade) throws EngineException {
        this.logger.trace("skipping FORCE-MERGE on shadow engine", new Object[0]);
    }

    @Override
    public Engine.GetResult get(Engine.Get get) throws EngineException {
        return this.getFromSearcher(get);
    }

    @Override
    public List<Segment> segments() {
        try (ReleasableLock lock = this.readLock.acquire();){
            Segment[] segmentsArr = this.getSegmentInfo(this.lastCommittedSegmentInfos);
            for (int i = 0; i < segmentsArr.length; ++i) {
                segmentsArr[i].committed = true;
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    @Override
    public boolean possibleMergeNeeded() {
        return false;
    }

    @Override
    public void maybeMerge() throws EngineException {
    }

    @Override
    public void refresh(String source) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.searcherManager.maybeRefreshBlocking();
        }
        catch (AlreadyClosedException e) {
            this.ensureOpen();
        }
        catch (EngineClosedException e) {
            throw e;
        }
        catch (Throwable t) {
            this.failEngine("refresh failed", t);
            throw new RefreshFailedEngineException(this.shardId, t);
        }
    }

    @Override
    public SnapshotIndexCommit snapshotIndex() throws EngineException {
        throw new UnsupportedOperationException("Can not take snapshot from a shadow engine");
    }

    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        throw new UnsupportedOperationException("Can not recover from a shadow engine");
    }

    @Override
    protected SearcherManager getSearcherManager() {
        return this.searcherManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNoLock(String reason) throws ElasticsearchException {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.logger.debug("shadow replica close searcher manager refCount: {}", this.store.refCount());
                IOUtils.close((Closeable[])new Closeable[]{this.searcherManager});
            }
            catch (Throwable t) {
                this.logger.warn("shadow replica failed to close searcher manager", t, new Object[0]);
            }
            finally {
                this.store.decRef();
            }
        }
    }
}

