/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local.state.shards;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.local.state.meta.CorruptStateException;
import org.elasticsearch.gateway.local.state.meta.MetaDataStateFormat;
import org.elasticsearch.gateway.local.state.shards.ShardStateInfo;
import org.elasticsearch.gateway.local.state.shards.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;

public class LocalGatewayShardsState
extends AbstractComponent
implements ClusterStateListener {
    private static final String SHARD_STATE_FILE_PREFIX = "state-";
    private static final Pattern SHARD_STATE_FILE_PATTERN = Pattern.compile("state-(\\d+)(.st)?");
    private static final String PRIMARY_KEY = "primary";
    private static final String VERSION_KEY = "version";
    private final NodeEnvironment nodeEnv;
    private volatile Map<ShardId, ShardStateInfo> currentState = Maps.newHashMap();

    @Inject
    public LocalGatewayShardsState(Settings settings, NodeEnvironment nodeEnv, TransportNodesListGatewayStartedShards listGatewayStartedShards) throws Exception {
        super(settings);
        this.nodeEnv = nodeEnv;
        listGatewayStartedShards.initGateway(this);
        if (DiscoveryNode.dataNode(settings)) {
            try {
                this.pre019Upgrade();
                long start = System.currentTimeMillis();
                this.currentState = this.loadShardsStateInfo();
                this.logger.debug("took {} to load started shards state", TimeValue.timeValueMillis(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                this.logger.error("failed to read local state (started shards), exiting...", e, new Object[0]);
                throw e;
            }
        }
    }

    public ShardStateInfo loadShardInfo(ShardId shardId) throws Exception {
        return this.loadShardStateInfo(shardId);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        if (!event.state().nodes().localNode().dataNode()) {
            return;
        }
        if (!event.routingTableChanged()) {
            return;
        }
        HashMap<ShardId, ShardStateInfo> newState = Maps.newHashMap();
        newState.putAll(this.currentState);
        for (IndexRoutingTable indexRoutingTable : event.state().routingTable()) {
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                if (indexShardRoutingTable.countWithState(ShardRoutingState.STARTED) != indexShardRoutingTable.size()) continue;
                newState.remove(indexShardRoutingTable.shardId());
            }
        }
        for (ShardId shardId : this.currentState.keySet()) {
            if (event.state().metaData().hasIndex(shardId.index().name())) continue;
            newState.remove(shardId);
        }
        RoutingNode routingNode = event.state().readOnlyRoutingNodes().node(event.state().nodes().localNodeId());
        if (routingNode != null) {
            for (MutableShardRouting shardRouting : routingNode) {
                if (!shardRouting.active()) continue;
                newState.put(shardRouting.shardId(), new ShardStateInfo(shardRouting.version(), shardRouting.primary()));
            }
        }
        Iterator it = newState.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ShardId shardId = (ShardId)entry.getKey();
            ShardStateInfo shardStateInfo = (ShardStateInfo)entry.getValue();
            String writeReason = null;
            ShardStateInfo currentShardStateInfo = this.currentState.get(shardId);
            if (currentShardStateInfo == null) {
                writeReason = "freshly started, version [" + shardStateInfo.version + "]";
            } else if (currentShardStateInfo.version != shardStateInfo.version) {
                writeReason = "version changed from [" + currentShardStateInfo.version + "] to [" + shardStateInfo.version + "]";
            }
            if (writeReason == null) continue;
            try {
                this.writeShardState(writeReason, shardId, shardStateInfo, currentShardStateInfo);
            }
            catch (Exception e) {
                it.remove();
            }
        }
        this.currentState = newState;
    }

    private Map<ShardId, ShardStateInfo> loadShardsStateInfo() throws Exception {
        Set<ShardId> shardIds = this.nodeEnv.findAllShardIds();
        long highestVersion = -1L;
        HashMap<ShardId, ShardStateInfo> shardsState = Maps.newHashMap();
        for (ShardId shardId : shardIds) {
            ShardStateInfo shardStateInfo = this.loadShardStateInfo(shardId);
            if (shardStateInfo == null) continue;
            shardsState.put(shardId, shardStateInfo);
            if (shardStateInfo.version <= highestVersion) continue;
            highestVersion = shardStateInfo.version;
        }
        return shardsState;
    }

    private ShardStateInfo loadShardStateInfo(ShardId shardId) {
        return MetaDataStateFormat.loadLatestState(this.logger, this.newShardStateInfoFormat(false), SHARD_STATE_FILE_PATTERN, shardId.toString(), this.nodeEnv.shardLocations(shardId));
    }

    private void writeShardState(String reason, ShardId shardId, ShardStateInfo shardStateInfo, @Nullable ShardStateInfo previousStateInfo) throws Exception {
        this.logger.trace("{} writing shard state, reason [{}]", shardId, reason);
        boolean deleteOldFiles = previousStateInfo != null && previousStateInfo.version != shardStateInfo.version;
        this.newShardStateInfoFormat(deleteOldFiles).write(shardStateInfo, SHARD_STATE_FILE_PREFIX, shardStateInfo.version, this.nodeEnv.shardLocations(shardId));
    }

    private MetaDataStateFormat<ShardStateInfo> newShardStateInfoFormat(boolean deleteOldFiles) {
        return new MetaDataStateFormat<ShardStateInfo>(XContentType.JSON, deleteOldFiles){

            @Override
            protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
                XContentBuilder xContentBuilder = super.newXContentBuilder(type, stream);
                xContentBuilder.prettyPrint();
                return xContentBuilder;
            }

            @Override
            public void toXContent(XContentBuilder builder, ShardStateInfo shardStateInfo) throws IOException {
                builder.field(LocalGatewayShardsState.VERSION_KEY, shardStateInfo.version);
                if (shardStateInfo.primary != null) {
                    builder.field(LocalGatewayShardsState.PRIMARY_KEY, (Object)shardStateInfo.primary);
                }
            }

            @Override
            public ShardStateInfo fromXContent(XContentParser parser) throws IOException {
                XContentParser.Token token = parser.nextToken();
                if (token == null) {
                    return null;
                }
                long version = -1L;
                Boolean primary = null;
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (LocalGatewayShardsState.VERSION_KEY.equals(currentFieldName)) {
                            version = parser.longValue();
                            continue;
                        }
                        if (LocalGatewayShardsState.PRIMARY_KEY.equals(currentFieldName)) {
                            primary = parser.booleanValue();
                            continue;
                        }
                        throw new CorruptStateException("unexpected field in shard state [" + currentFieldName + "]");
                    }
                    throw new CorruptStateException("unexpected token in shard state [" + token.name() + "]");
                }
                if (primary == null) {
                    throw new CorruptStateException("missing value for [primary] in shard state");
                }
                if (version == -1L) {
                    throw new CorruptStateException("missing value for [version] in shard state");
                }
                return new ShardStateInfo(version, primary);
            }
        };
    }

    private void pre019Upgrade() throws Exception {
        long index = -1L;
        File latest = null;
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File stateLocation = new File(dataLocation, "_state");
            File[] stateFiles = stateLocation.listFiles();
            if (stateFiles == null) continue;
            for (File stateFile : stateFiles) {
                long fileIndex;
                String name;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[find_latest_state]: processing [" + stateFile.getName() + "]", new Object[0]);
                }
                if (!(name = stateFile.getName()).startsWith("shards-") || (fileIndex = Long.parseLong(name.substring(name.indexOf(45) + 1))) < index) continue;
                try {
                    byte[] data = Streams.copyToByteArray(new FileInputStream(stateFile));
                    if (data.length == 0) {
                        this.logger.debug("[upgrade]: not data for [" + name + "], ignoring...", new Object[0]);
                    }
                    this.pre09ReadState(data);
                    index = fileIndex;
                    latest = stateFile;
                }
                catch (IOException e) {
                    this.logger.warn("[upgrade]: failed to read state from [" + name + "], ignoring...", e, new Object[0]);
                }
            }
        }
        if (latest == null) {
            return;
        }
        this.logger.info("found old shards state, loading started shards from [{}] and converting to new shards state locations...", latest.getAbsolutePath());
        Map<ShardId, ShardStateInfo> shardsState = this.pre09ReadState(Streams.copyToByteArray(new FileInputStream(latest)));
        for (Map.Entry<ShardId, ShardStateInfo> entry : shardsState.entrySet()) {
            this.writeShardState("upgrade", entry.getKey(), entry.getValue(), null);
        }
        File backupFile = new File(latest.getParentFile(), "backup-" + latest.getName());
        if (!latest.renameTo(backupFile)) {
            throw new IOException("failed to rename old state to backup state [" + latest.getAbsolutePath() + "]");
        }
        for (File dataLocation : this.nodeEnv.nodeDataLocations()) {
            File stateLocation = new File(dataLocation, "_state");
            File[] stateFiles = stateLocation.listFiles();
            if (stateFiles == null) continue;
            for (File stateFile : stateFiles) {
                String name = stateFile.getName();
                if (!name.startsWith("shards-")) continue;
                stateFile.delete();
            }
        }
        this.logger.info("conversion to new shards state location and format done, backup create at [{}]", backupFile.getAbsolutePath());
    }

    private Map<ShardId, ShardStateInfo> pre09ReadState(byte[] data) throws IOException {
        HashMap<ShardId, ShardStateInfo> shardsState = Maps.newHashMap();
        try (XContentParser parser = XContentHelper.createParser(data, 0, data.length);){
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                HashMap<ShardId, ShardStateInfo> hashMap = shardsState;
                return hashMap;
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY || !"shards".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token != XContentParser.Token.START_OBJECT) continue;
                    String shardIndex = null;
                    int shardId = -1;
                    long version = -1L;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (!token.isValue()) continue;
                        if ("index".equals(currentFieldName)) {
                            shardIndex = parser.text();
                            continue;
                        }
                        if ("id".equals(currentFieldName)) {
                            shardId = parser.intValue();
                            continue;
                        }
                        if (!VERSION_KEY.equals(currentFieldName)) continue;
                        version = parser.longValue();
                    }
                    shardsState.put(new ShardId(shardIndex, shardId), new ShardStateInfo(version, null));
                }
            }
            HashMap<ShardId, ShardStateInfo> hashMap = shardsState;
            return hashMap;
        }
    }
}

