/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.discovery.zen.elect.ElectMasterService;
import org.elasticsearch.discovery.zen.ping.PingContextProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.multicast.MulticastZenPing;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class ZenPingService
extends AbstractLifecycleComponent<ZenPing>
implements ZenPing {
    private volatile ImmutableList<? extends ZenPing> zenPings = ImmutableList.of();

    public ZenPingService(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName, NetworkService networkService, ElectMasterService electMasterService, @Nullable Set<UnicastHostsProvider> unicastHostsProviders) {
        this(settings, threadPool, transportService, clusterName, networkService, Version.CURRENT, electMasterService, unicastHostsProviders);
    }

    @Inject
    public ZenPingService(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName, NetworkService networkService, Version version, ElectMasterService electMasterService, @Nullable Set<UnicastHostsProvider> unicastHostsProviders) {
        super(settings);
        ImmutableList.Builder zenPingsBuilder = ImmutableList.builder();
        if (this.componentSettings.getAsBoolean("multicast.enabled", (Boolean)true).booleanValue()) {
            zenPingsBuilder.add(new MulticastZenPing(settings, threadPool, transportService, clusterName, networkService, version));
        }
        zenPingsBuilder.add(new UnicastZenPing(settings, threadPool, transportService, clusterName, version, electMasterService, unicastHostsProviders));
        this.zenPings = zenPingsBuilder.build();
    }

    public ImmutableList<? extends ZenPing> zenPings() {
        return this.zenPings;
    }

    public void zenPings(ImmutableList<? extends ZenPing> pings) {
        block3: {
            block2: {
                this.zenPings = pings;
                if (!this.lifecycle.started()) break block2;
                for (ZenPing zenPing : this.zenPings) {
                    zenPing.start();
                }
                break block3;
            }
            if (!this.lifecycle.stopped()) break block3;
            for (ZenPing zenPing : this.zenPings) {
                zenPing.stop();
            }
        }
    }

    @Override
    public void setPingContextProvider(PingContextProvider contextProvider) {
        if (this.lifecycle.started()) {
            throw new ElasticsearchIllegalStateException("Can't set nodes provider when started");
        }
        for (ZenPing zenPing : this.zenPings) {
            zenPing.setPingContextProvider(contextProvider);
        }
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.start();
        }
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.stop();
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        for (ZenPing zenPing : this.zenPings) {
            zenPing.close();
        }
    }

    public ZenPing.PingResponse[] pingAndWait(TimeValue timeout) {
        final AtomicReference response = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.ping(new ZenPing.PingListener(){

            @Override
            public void onPing(ZenPing.PingResponse[] pings) {
                response.set(pings);
                latch.countDown();
            }
        }, timeout);
        try {
            latch.await();
            return (ZenPing.PingResponse[])response.get();
        }
        catch (InterruptedException e) {
            this.logger.trace("pingAndWait interrupted", new Object[0]);
            return null;
        }
    }

    @Override
    public void ping(ZenPing.PingListener listener, TimeValue timeout) throws ElasticsearchException {
        ImmutableList<? extends ZenPing> zenPings = this.zenPings;
        CompoundPingListener compoundPingListener = new CompoundPingListener(listener, zenPings);
        for (ZenPing zenPing : zenPings) {
            try {
                zenPing.ping(compoundPingListener, timeout);
            }
            catch (EsRejectedExecutionException ex) {
                this.logger.debug("Ping execution rejected", ex, new Object[0]);
                compoundPingListener.onPing(null);
            }
        }
    }

    private static class CompoundPingListener
    implements ZenPing.PingListener {
        private final ZenPing.PingListener listener;
        private final AtomicInteger counter;
        private ZenPing.PingCollection responses = new ZenPing.PingCollection();

        private CompoundPingListener(ZenPing.PingListener listener, ImmutableList<? extends ZenPing> zenPings) {
            this.listener = listener;
            this.counter = new AtomicInteger(zenPings.size());
        }

        @Override
        public void onPing(ZenPing.PingResponse[] pings) {
            if (pings != null) {
                this.responses.addPings(pings);
            }
            if (this.counter.decrementAndGet() == 0) {
                this.listener.onPing(this.responses.toArray());
            }
        }
    }
}

