/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MethodInjectorImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
public class WorkdirInjectorFactory
extends InjectorFactoryImpl {
    private static final Logger logger = LoggerFactory.getLogger(WorkdirInjectorFactory.class);

    public MethodInjector createMethodInjector(ResourceLocator method, ResteasyProviderFactory factory) {
        return new WorkdirMethodInjector(method, factory);
    }

    public static class WorkdirMethodInjector
    extends MethodInjectorImpl {
        private final ResourceLocator resourceLocator;

        public WorkdirMethodInjector(ResourceLocator resourceLocator, ResteasyProviderFactory factory) {
            super(resourceLocator, factory);
            this.resourceLocator = resourceLocator;
        }

        public Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure, ApplicationException, WebApplicationException {
            try {
                Method realMethod = resource.getClass().getMethod(this.method.getMethod().getName(), this.resourceLocator.getMethod().getParameterTypes());
                if (realMethod.isAnnotationPresent(Workdir.class)) {
                    String prefix = realMethod.getAnnotation(Workdir.class).prefix();
                    logger.trace("Initializing WorkDir for method [{}] with prefix [{}]", (Object)this.method, (Object)prefix);
                    WorkdirHolder.initWorkdir(prefix);
                }
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
            return super.invoke(request, httpResponse, resource);
        }
    }
}

