/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class GossipData
implements SizeStreamable {
    byte type;
    String group;
    Address addr;
    String logical_name;
    List<Address> mbrs;
    PhysicalAddress physical_addr;
    byte[] buffer;
    int offset;
    int length;

    public GossipData() {
    }

    public GossipData(byte type) {
        this.type = type;
    }

    public GossipData(byte type, String group, Address addr) {
        this(type);
        this.group = group;
        this.addr = addr;
    }

    public GossipData(byte type, String group, Address addr, List<Address> mbrs) {
        this(type, group, addr);
        this.mbrs = mbrs;
    }

    @Deprecated
    public GossipData(byte type, String group, Address addr, List<Address> mbrs, List<PhysicalAddress> physical_addrs) {
        this(type, group, addr, mbrs);
        if (physical_addrs != null && !physical_addrs.isEmpty()) {
            this.physical_addr = physical_addrs.get(0);
        }
    }

    public GossipData(byte type, String group, Address addr, List<Address> mbrs, PhysicalAddress physical_addr) {
        this(type, group, addr, mbrs);
        this.physical_addr = physical_addr;
    }

    @Deprecated
    public GossipData(byte type, String group, Address addr, String logical_name, List<PhysicalAddress> physical_addrs) {
        this(type, group, addr);
        this.logical_name = logical_name;
        if (physical_addrs != null && !physical_addrs.isEmpty()) {
            this.physical_addr = physical_addrs.get(0);
        }
    }

    public GossipData(byte type, String group, Address addr, String logical_name, PhysicalAddress physical_addr) {
        this(type, group, addr);
        this.logical_name = logical_name;
        this.physical_addr = physical_addr;
    }

    public GossipData(byte type, String group, Address addr, byte[] buffer) {
        this(type, group, addr, buffer, 0, buffer.length);
    }

    public GossipData(byte type, String group, Address addr, byte[] buffer, int offset, int length) {
        this(type, group, addr);
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public byte getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public Address getAddress() {
        return this.addr;
    }

    public String getLogicalName() {
        return this.logical_name;
    }

    public List<Address> getMembers() {
        return this.mbrs;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Deprecated
    public Collection<PhysicalAddress> getPhysicalAddresses() {
        return Arrays.asList(this.physical_addr);
    }

    public PhysicalAddress getPhysicalAddress() {
        return this.physical_addr;
    }

    public void setMembers(List<Address> mbrs) {
        this.mbrs = mbrs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GossipRouter.type2String(this.type)).append("(").append("group=").append(this.group).append(", addr=").append(this.addr);
        if (this.logical_name != null) {
            sb.append(", logical_name=" + this.logical_name);
        }
        if (this.mbrs != null && !this.mbrs.isEmpty()) {
            sb.append(", mbrs=").append(this.mbrs);
        }
        if (this.physical_addr != null) {
            sb.append(", physical_addr=").append(this.physical_addr);
        }
        if (this.buffer != null) {
            sb.append(", buffer: " + this.length + " bytes");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeByte(this.type);
        Bits.writeString(this.group, out);
        Util.writeAddress(this.addr, out);
        Bits.writeString(this.logical_name, out);
        Util.writeAddresses(this.mbrs, out);
        Util.writeAddress(this.physical_addr, out);
        Util.writeByteBuffer(this.buffer, this.offset, this.length, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.type = in.readByte();
        this.group = Bits.readString(in);
        this.addr = Util.readAddress(in);
        this.logical_name = Bits.readString(in);
        this.mbrs = (List)Util.readAddresses(in, LinkedList.class);
        this.physical_addr = (PhysicalAddress)Util.readAddress(in);
        this.buffer = Util.readByteBuffer(in);
        if (this.buffer != null) {
            this.offset = 0;
            this.length = this.buffer.length;
        }
    }

    @Override
    public int size() {
        int retval = 1;
        retval += 3;
        if (this.group != null) {
            retval += this.group.length() + 2;
        }
        retval += Util.size(this.addr);
        if (this.logical_name != null) {
            retval += this.logical_name.length() + 2;
        }
        retval = (int)((long)retval + Util.size(this.mbrs));
        retval += Util.size(this.physical_addr);
        if (this.buffer != null) {
            retval += 4 + this.length;
        }
        return retval;
    }
}

