/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.serialize.BasicMessageBodyWriter;
import com.xebialabs.xltest.view.ListOfTestRuns;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class ListOfTestRunsWriter
extends BasicMessageBodyWriter<ListOfTestRuns> {
    @Override
    protected void writeJson(ListOfTestRuns testRuns, JSONWriter writer) throws JSONException {
        writer.array();
        for (TestRun testRun : testRuns) {
            this.writeJson(testRun, writer);
        }
        writer.endArray();
    }

    @Override
    protected void writeJson(TestRun testRun, JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("id").value((Object)testRun.getId());
        writer.key("startTime").value((Object)this.convert(testRun.getStartTime()));
        writer.key("finishedTime").value((Object)this.convert(testRun.getFinishedTime()));
        writer.key("qualificationResult").value(testRun.getQualificationResult());
        writer.key("testSpecificationName").value((Object)testRun.getTestSpecificationName());
        writer.endObject();
    }

    private String convert(Date value) {
        if (value == null) {
            return null;
        }
        return ISODateTimeFormat.dateTime().print(value.getTime());
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ListOfTestRuns.class.isAssignableFrom(type);
    }
}

