/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.base.Objects;
import com.xebialabs.xltest.domain.TestTool;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.SubTypeScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TestToolRepository {
    private static final Logger LOG = LoggerFactory.getLogger(TestToolRepository.class);
    private final Map<String, TestTool> testTools;

    public TestToolRepository() {
        Configuration config = Configuration.config().with(new AbstractScanner[]{new SubTypeScanner()}).scan("com.xebialabs.xltest");
        Scannit scannit = new Scannit(config);
        HashMap<String, TestTool> testTools = new HashMap<String, TestTool>();
        for (Class testToolClass : scannit.getSubTypesOf(TestTool.class)) {
            if (Modifier.isAbstract(testToolClass.getModifiers())) continue;
            try {
                TestTool testTool = (TestTool)testToolClass.newInstance();
                String name = testTool.getName();
                if (testTools.containsKey(name)) {
                    throw new IllegalStateException(String.format("Have two tools with name '%s'", name));
                }
                testTools.put(name, testTool);
                LOG.info("Registered test tool name='{}' class='{}'", (Object)name, (Object)testToolClass.getCanonicalName());
            }
            catch (InstantiationException e) {
                LOG.error("Unable register test tool, unable to instantiate class '{}'", (Object)testToolClass.getCanonicalName());
            }
            catch (Exception e) {
                LOG.error("Unable register test tool '{}' '{}'", (Object)testToolClass.getCanonicalName(), (Object)e.getMessage());
            }
        }
        this.testTools = Collections.unmodifiableMap(testTools);
    }

    public TestToolRepository(TestTool testTool) {
        this.testTools = new HashMap<String, TestTool>();
        this.testTools.put(testTool.getName(), testTool);
    }

    public TestTool findByName(String name) {
        TestTool testTool = this.testTools.get(name);
        if (testTool == null) {
            throw new IllegalArgumentException(String.format("No test tool could be found with name '%s'", name));
        }
        return testTool;
    }

    public Collection<TestTool> getTestTools() {
        return this.testTools.values();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("testTools", this.testTools).toString();
    }
}

