/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.domain.TestRunImpl;
import com.xebialabs.xltest.repository.TestRunsRepository;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.script.ScriptContext;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(description="Base type for test run qualifiers.", root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class Qualification
extends ScriptedConfigurationItem {
    private static final Logger LOG = LoggerFactory.getLogger(Qualification.class);

    public static Qualification getQualificationFor(String qualificationType) {
        Preconditions.checkNotNull((Object)qualificationType);
        return (Qualification)DescriptorRegistry.getDescriptor((String)qualificationType).newInstance(UUID.randomUUID().toString());
    }

    public Qualifier getQualifier(final UUID testRunId, final TestRunsRepository testRunsRepository) {
        return new Qualifier(){
            private List<Event> events = new ArrayList<Event>();

            @Override
            public void update(Event event) {
                this.events.add(event);
            }

            @Override
            public QualificationResult getQualificationResult() {
                if (this.events.size() == 0) {
                    return new QualificationResult(QualificationResult.Result.NOT_FOUND, DateTime.now(), "No events have been found");
                }
                ScriptContext context = Qualification.this.newScriptContext();
                context.setAttribute("events", this.events, 100);
                context.setAttribute("testRun", new TestRunImpl(this.events), 100);
                context.setAttribute("testRuns", testRunsRepository, 100);
                testRunsRepository.refreshIndex();
                try {
                    LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>((Map)Qualification.this.execute(context, Qualification.this));
                    Boolean success = (Boolean)result.remove("success");
                    String reason = (String)result.remove("reason");
                    return new QualificationResult(Qualification.this.toResult(success), DateTime.now(), reason, result);
                }
                catch (Exception e) {
                    LOG.warn("Unable to calculate qualification for test run {}: {}", (Object)testRunId, (Object)e.getMessage());
                    LOG.debug("Qualification calculation error", (Throwable)e);
                    return new QualificationResult(QualificationResult.Result.FAILED, DateTime.now(), "Could not calculate qualification: " + e.getMessage());
                }
            }

            @Override
            public Event getEvent() {
                QualificationResult qualificationResult = this.getQualificationResult();
                LOG.debug("QualificationResult: {}", (Object)qualificationResult);
                Event event = new Event(testRunId, "qualificationComputed", Event.props(qualificationResult.getOtherProperties(), (Object[])new Object[]{"qualification", qualificationResult.getQualification(), "failureReason", qualificationResult.getFailureReason()}));
                return event;
            }
        };
    }

    private QualificationResult.Result toResult(Boolean success) {
        if (success == null) {
            return QualificationResult.Result.NOT_FOUND;
        }
        if (success.booleanValue()) {
            return QualificationResult.Result.PASSED;
        }
        return QualificationResult.Result.FAILED;
    }
}

