/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.IndexDeleteRequest;
import org.elasticsearch.action.delete.IndexDeleteResponse;
import org.elasticsearch.action.delete.ShardDeleteResponse;
import org.elasticsearch.action.delete.TransportIndexDeleteAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteAction
extends TransportShardReplicationOperationAction<DeleteRequest, DeleteRequest, DeleteResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;
    private final TransportIndexDeleteAction indexDeleteAction;

    @Inject
    public TransportDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, TransportCreateIndexAction createIndexAction, TransportIndexDeleteAction indexDeleteAction, ActionFilters actionFilters) {
        super(settings, "indices:data/write/delete", transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters);
        this.createIndexAction = createIndexAction;
        this.indexDeleteAction = indexDeleteAction;
        this.autoCreateIndex = new AutoCreateIndex(settings);
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected void doExecute(final DeleteRequest request, final ActionListener<DeleteResponse> listener) {
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            request.beforeLocalFork();
            this.createIndexAction.execute(new CreateIndexRequest(request).index(request.index()).cause("auto(delete api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportDeleteAction.this.innerExecute(request, listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        TransportDeleteAction.this.innerExecute(request, listener);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(request, listener);
        }
    }

    @Override
    protected boolean resolveIndex() {
        return true;
    }

    @Override
    protected boolean resolveRequest(ClusterState state, final TransportShardReplicationOperationAction.InternalRequest request, final ActionListener<DeleteResponse> listener) {
        MappingMetaData mappingMd;
        ((DeleteRequest)request.request()).routing(state.metaData().resolveIndexRouting(((DeleteRequest)request.request()).routing(), ((DeleteRequest)request.request()).index()));
        if (state.metaData().hasIndex(request.concreteIndex()) && (mappingMd = state.metaData().index(request.concreteIndex()).mappingOrDefault(((DeleteRequest)request.request()).type())) != null && mappingMd.routing().required() && ((DeleteRequest)request.request()).routing() == null) {
            if (((DeleteRequest)request.request()).versionType() != VersionType.INTERNAL) {
                throw new ElasticsearchIllegalArgumentException("routing value is required for deleting documents of type [" + ((DeleteRequest)request.request()).type() + "] while using version_type [" + (Object)((Object)((DeleteRequest)request.request()).versionType()) + "]");
            }
            this.indexDeleteAction.execute(new IndexDeleteRequest((DeleteRequest)request.request(), request.concreteIndex()), new ActionListener<IndexDeleteResponse>(){

                @Override
                public void onResponse(IndexDeleteResponse indexDeleteResponse) {
                    long version = -3L;
                    boolean found = false;
                    for (ShardDeleteResponse deleteResponse : indexDeleteResponse.getResponses()) {
                        if (!deleteResponse.isFound()) continue;
                        version = deleteResponse.getVersion();
                        found = true;
                        break;
                    }
                    listener.onResponse(new DeleteResponse(request.concreteIndex(), ((DeleteRequest)request.request()).type(), ((DeleteRequest)request.request()).id(), version, found));
                }

                @Override
                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            });
            return false;
        }
        return true;
    }

    private void innerExecute(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        super.doExecute(request, listener);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected DeleteRequest newRequestInstance() {
        return new DeleteRequest();
    }

    @Override
    protected DeleteRequest newReplicaRequestInstance() {
        return new DeleteRequest();
    }

    @Override
    protected DeleteResponse newResponseInstance() {
        return new DeleteResponse();
    }

    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<DeleteResponse, DeleteRequest> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.PrimaryOperationRequest shardRequest) {
        DeleteRequest request = (DeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRequest.shardId.getIndex()).shardSafe(shardRequest.shardId.id());
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version(), request.versionType(), Engine.Operation.Origin.PRIMARY);
        indexShard.delete(delete);
        request.versionType(delete.versionType().versionTypeForReplicationAndRecovery());
        request.version(delete.version());
        assert (request.versionType().validateVersionForWrites(request.version()));
        if (request.refresh()) {
            try {
                indexShard.refresh("refresh_flag_delete");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DeleteResponse response = new DeleteResponse(shardRequest.shardId.getIndex(), request.type(), request.id(), delete.version(), delete.found());
        return new TransportShardReplicationOperationAction.PrimaryResponse<DeleteResponse, DeleteRequest>((DeleteRequest)shardRequest.request, response, null);
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ReplicaOperationRequest shardRequest) {
        DeleteRequest request = (DeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRequest.shardId.getIndex()).shardSafe(shardRequest.shardId.id());
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version(), request.versionType(), Engine.Operation.Origin.REPLICA);
        indexShard.delete(delete);
        if (request.refresh()) {
            try {
                indexShard.refresh("refresh_flag_delete");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, TransportShardReplicationOperationAction.InternalRequest request) {
        return this.clusterService.operationRouting().deleteShards(this.clusterService.state(), request.concreteIndex(), ((DeleteRequest)request.request()).type(), ((DeleteRequest)request.request()).id(), ((DeleteRequest)request.request()).routing());
    }
}

