/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.domain.BaseTestTool;
import com.xebialabs.xltest.domain.ImportFailedException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.fitnesse.PageHistoryExtractor;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FitNesseTestTool
extends BaseTestTool {
    private static final Logger LOG = LoggerFactory.getLogger(FitNesseTestTool.class);

    public String getName() {
        return "FitNesse";
    }

    public List<Importable> findImportables(OverthereFile remoteResultPath, FileMatcher fileMatcher) throws ImportFailedException {
        LOG.debug("findImportables({},{})", (Object)remoteResultPath, (Object)fileMatcher);
        LocalFile resultPath = this.retrieveFiles(remoteResultPath);
        SortedSet fitNesseRoots = this.findTestResultPaths((OverthereFile)resultPath, fileMatcher);
        try {
            ArrayList<Importable> importables = new ArrayList<Importable>();
            for (OverthereFile fitNesseRoot : fitNesseRoots) {
                LocalFile localFile = (LocalFile)fitNesseRoot;
                importables.addAll(new PageHistoryExtractor(localFile.getFile()).createImportables());
            }
            return importables;
        }
        catch (Exception e) {
            throw new ImportFailedException("Unable to determine what to import from FitNesse path " + remoteResultPath, (Throwable)e);
        }
    }

    public String getDefaultSearchPattern() {
        return "**/FitNesseRoot";
    }

    public String getCategory() {
        return "functional";
    }
}

