/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.HashSet;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;

public class SnapshotUtils {
    public static ImmutableList<String> filterIndices(ImmutableList<String> availableIndices, String[] selectedIndices, IndicesOptions indicesOptions) {
        if (selectedIndices == null || selectedIndices.length == 0) {
            return availableIndices;
        }
        HashSet<Object> result = null;
        for (int i = 0; i < selectedIndices.length; ++i) {
            String indexOrPattern = selectedIndices[i];
            boolean add = true;
            if (!indexOrPattern.isEmpty()) {
                if (availableIndices.contains(indexOrPattern)) {
                    if (result == null) continue;
                    result.add(indexOrPattern);
                    continue;
                }
                if (indexOrPattern.charAt(0) == '+') {
                    add = true;
                    indexOrPattern = indexOrPattern.substring(1);
                    if (i == 0) {
                        result = new HashSet();
                    }
                } else if (indexOrPattern.charAt(0) == '-') {
                    if (i == 0) {
                        result = new HashSet<String>(availableIndices);
                    }
                    add = false;
                    indexOrPattern = indexOrPattern.substring(1);
                }
            }
            if (indexOrPattern.isEmpty() || !Regex.isSimpleMatchPattern(indexOrPattern)) {
                if (!availableIndices.contains(indexOrPattern)) {
                    if (!indicesOptions.ignoreUnavailable()) {
                        throw new IndexMissingException(new Index(indexOrPattern));
                    }
                    if (result != null) continue;
                    result = new HashSet();
                    result.addAll(availableIndices.subList(0, i));
                    continue;
                }
                if (result == null) continue;
                if (add) {
                    result.add(indexOrPattern);
                    continue;
                }
                result.remove(indexOrPattern);
                continue;
            }
            if (result == null) {
                result = new HashSet<String>();
                result.addAll(availableIndices.subList(0, i));
            }
            boolean found = false;
            for (String index : availableIndices) {
                if (!Regex.simpleMatch(indexOrPattern, index)) continue;
                found = true;
                if (add) {
                    result.add(index);
                    continue;
                }
                result.remove(index);
            }
            if (found || indicesOptions.allowNoIndices()) continue;
            throw new IndexMissingException(new Index(indexOrPattern));
        }
        if (result == null) {
            return ImmutableList.copyOf(selectedIndices);
        }
        return ImmutableList.copyOf(result);
    }
}

