/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;

public class SignificanceHeuristicParserMapper {
    protected ImmutableMap<String, SignificanceHeuristicParser> significanceHeuristicParsers;

    @Inject
    public SignificanceHeuristicParserMapper(Set<SignificanceHeuristicParser> parsers) {
        MapBuilder<String, SignificanceHeuristicParser> builder = MapBuilder.newMapBuilder();
        for (SignificanceHeuristicParser parser : parsers) {
            for (String name : parser.getNames()) {
                builder.put(name, parser);
            }
        }
        this.significanceHeuristicParsers = builder.immutableMap();
    }

    public SignificanceHeuristicParser get(String parserName) {
        return this.significanceHeuristicParsers.get(parserName);
    }
}

