/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node.service;

import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class NodeService
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final MonitorService monitorService;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final PluginsService pluginService;
    private final CircuitBreakerService circuitBreakerService;
    @Nullable
    private HttpServer httpServer;
    private volatile ImmutableMap<String, String> serviceAttributes = ImmutableMap.of();
    private final Version version;
    private final Discovery discovery;

    @Inject
    public NodeService(Settings settings, ThreadPool threadPool, MonitorService monitorService, Discovery discovery, TransportService transportService, IndicesService indicesService, PluginsService pluginService, CircuitBreakerService circuitBreakerService, Version version) {
        super(settings);
        this.threadPool = threadPool;
        this.monitorService = monitorService;
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.discovery = discovery;
        discovery.setNodeService(this);
        this.version = version;
        this.pluginService = pluginService;
        this.circuitBreakerService = circuitBreakerService;
    }

    public void setHttpServer(@Nullable HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    @Deprecated
    public void putNodeAttribute(String key, String value) {
        this.putAttribute(key, value);
    }

    @Deprecated
    public void removeNodeAttribute(String key) {
        this.removeAttribute(key);
    }

    public synchronized void putAttribute(String key, String value) {
        this.serviceAttributes = new MapBuilder<String, String>(this.serviceAttributes).put(key, value).immutableMap();
    }

    public synchronized void removeAttribute(String key) {
        this.serviceAttributes = new MapBuilder<String, String>(this.serviceAttributes).remove(key).immutableMap();
    }

    public ImmutableMap<String, String> attributes() {
        return this.serviceAttributes;
    }

    public NodeInfo info() {
        return new NodeInfo(this.version, Build.CURRENT, this.discovery.localNode(), this.serviceAttributes, this.settings, this.monitorService.osService().info(), this.monitorService.processService().info(), this.monitorService.jvmService().info(), this.threadPool.info(), this.monitorService.networkService().info(), this.transportService.info(), this.httpServer == null ? null : this.httpServer.info(), this.pluginService == null ? null : this.pluginService.info());
    }

    public NodeInfo info(boolean settings, boolean os, boolean process, boolean jvm, boolean threadPool, boolean network, boolean transport, boolean http, boolean plugin) {
        return new NodeInfo(this.version, Build.CURRENT, this.discovery.localNode(), this.serviceAttributes, settings ? this.settings : null, os ? this.monitorService.osService().info() : null, process ? this.monitorService.processService().info() : null, jvm ? this.monitorService.jvmService().info() : null, threadPool ? this.threadPool.info() : null, network ? this.monitorService.networkService().info() : null, transport ? this.transportService.info() : null, http ? (this.httpServer == null ? null : this.httpServer.info()) : null, plugin ? (this.pluginService == null ? null : this.pluginService.info()) : null);
    }

    public NodeStats stats() {
        return new NodeStats(this.discovery.localNode(), System.currentTimeMillis(), this.indicesService.stats(true), this.monitorService.osService().stats(), this.monitorService.processService().stats(), this.monitorService.jvmService().stats(), this.threadPool.stats(), this.monitorService.networkService().stats(), this.monitorService.fsService().stats(), this.transportService.stats(), this.httpServer == null ? null : this.httpServer.stats(), this.circuitBreakerService.stats());
    }

    public NodeStats stats(CommonStatsFlags indices, boolean os, boolean process, boolean jvm, boolean threadPool, boolean network, boolean fs, boolean transport, boolean http, boolean circuitBreaker) {
        return new NodeStats(this.discovery.localNode(), System.currentTimeMillis(), indices.anySet() ? this.indicesService.stats(true, indices) : null, os ? this.monitorService.osService().stats() : null, process ? this.monitorService.processService().stats() : null, jvm ? this.monitorService.jvmService().stats() : null, threadPool ? this.threadPool.stats() : null, network ? this.monitorService.networkService().stats() : null, fs ? this.monitorService.fsService().stats() : null, transport ? this.transportService.stats() : null, http ? (this.httpServer == null ? null : this.httpServer.stats()) : null, circuitBreaker ? this.circuitBreakerService.stats() : null);
    }
}

