/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.http.websocketx;

import java.net.URI;
import java.util.Map;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelHandler;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.DefaultChannelFuture;
import org.elasticsearch.common.netty.handler.codec.http.DefaultHttpRequest;
import org.elasticsearch.common.netty.handler.codec.http.HttpMethod;
import org.elasticsearch.common.netty.handler.codec.http.HttpRequestEncoder;
import org.elasticsearch.common.netty.handler.codec.http.HttpResponse;
import org.elasticsearch.common.netty.handler.codec.http.HttpResponseStatus;
import org.elasticsearch.common.netty.handler.codec.http.HttpVersion;
import org.elasticsearch.common.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import org.elasticsearch.common.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import org.elasticsearch.common.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import org.elasticsearch.common.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.elasticsearch.common.netty.handler.codec.http.websocketx.WebSocketUtil;
import org.elasticsearch.common.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;
import org.elasticsearch.common.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketClientHandshaker08
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker08.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;

    public WebSocketClientHandshaker08(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, Map<String, String> customHeaders) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, Long.MAX_VALUE);
    }

    public WebSocketClientHandshaker08(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, Map<String, String> customHeaders, long maxFramePayloadLength) {
        super(webSocketURL, version, subprotocol, customHeaders, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    @Override
    public ChannelFuture handshake(Channel channel) throws Exception {
        URI wsURL = this.getWebSocketUrl();
        String path = wsURL.getPath();
        if (wsURL.getQuery() != null && wsURL.getQuery().length() > 0) {
            path = wsURL.getPath() + '?' + wsURL.getQuery();
        }
        if (path == null || path.length() == 0) {
            path = "/";
        }
        ChannelBuffer nonce = ChannelBuffers.wrappedBuffer(WebSocketUtil.randomBytes(16));
        String key = WebSocketUtil.base64(nonce);
        String acceptSeed = key + MAGIC_GUID;
        ChannelBuffer sha1 = WebSocketUtil.sha1(ChannelBuffers.copiedBuffer(acceptSeed, CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 08 Client Handshake key: %s. Expected response: %s.", key, this.expectedChallengeResponseString));
        }
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
        request.headers().add("Upgrade", "WebSocket".toLowerCase());
        request.headers().add("Connection", "Upgrade");
        request.headers().add("Sec-WebSocket-Key", key);
        request.headers().add("Host", wsURL.getHost());
        int wsPort = wsURL.getPort();
        String originValue = "http://" + wsURL.getHost();
        if (wsPort != 80 && wsPort != 443) {
            originValue = originValue + ':' + wsPort;
        }
        request.headers().add("Sec-WebSocket-Origin", originValue);
        String expectedSubprotocol = this.getExpectedSubprotocol();
        if (expectedSubprotocol != null && expectedSubprotocol.length() != 0) {
            request.headers().add("Sec-WebSocket-Protocol", expectedSubprotocol);
        }
        request.headers().add("Sec-WebSocket-Version", "8");
        if (this.customHeaders != null) {
            for (Map.Entry e : this.customHeaders.entrySet()) {
                request.headers().add((String)e.getKey(), e.getValue());
            }
        }
        final DefaultChannelFuture handshakeFuture = new DefaultChannelFuture(channel, false);
        ChannelFuture future = channel.write(request);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ChannelPipeline p = future.getChannel().getPipeline();
                p.replace(HttpRequestEncoder.class, "ws-encoder", (ChannelHandler)new WebSocket08FrameEncoder(true));
                if (future.isSuccess()) {
                    handshakeFuture.setSuccess();
                } else {
                    handshakeFuture.setFailure(future.getCause());
                }
            }
        });
        return handshakeFuture;
    }

    @Override
    public void finishHandshake(Channel channel, HttpResponse response) {
        HttpResponseStatus status = HttpResponseStatus.SWITCHING_PROTOCOLS;
        if (!response.getStatus().equals(status)) {
            throw new WebSocketHandshakeException("Invalid handshake response status: " + response.getStatus());
        }
        String upgrade = response.headers().get("Upgrade");
        if (upgrade == null || !upgrade.toLowerCase().equals("WebSocket".toLowerCase())) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + response.headers().get("Upgrade"));
        }
        String connection = response.headers().get("Connection");
        if (connection == null || !connection.toLowerCase().equals("Upgrade".toLowerCase())) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + response.headers().get("Connection"));
        }
        String accept = response.headers().get("Sec-WebSocket-Accept");
        if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString));
        }
        String subprotocol = response.headers().get("Sec-WebSocket-Protocol");
        this.setActualSubprotocol(subprotocol);
        this.setHandshakeComplete();
        WebSocketClientHandshaker08.replaceDecoder(channel, new WebSocket08FrameDecoder(false, this.allowExtensions, this.getMaxFramePayloadLength()));
    }
}

