/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class RepositoriesMetaData
implements MetaData.Custom {
    public static final String TYPE = "repositories";
    public static final Factory FACTORY = new Factory();
    private final ImmutableList<RepositoryMetaData> repositories;

    public RepositoriesMetaData(RepositoryMetaData ... repositories) {
        this.repositories = ImmutableList.copyOf(repositories);
    }

    public ImmutableList<RepositoryMetaData> repositories() {
        return this.repositories;
    }

    public RepositoryMetaData repository(String name) {
        for (RepositoryMetaData repository : this.repositories) {
            if (!name.equals(repository.name())) continue;
            return repository;
        }
        return null;
    }

    public static class Factory
    extends MetaData.Custom.Factory<RepositoriesMetaData> {
        @Override
        public String type() {
            return RepositoriesMetaData.TYPE;
        }

        @Override
        public RepositoriesMetaData readFrom(StreamInput in) throws IOException {
            RepositoryMetaData[] repository = new RepositoryMetaData[in.readVInt()];
            for (int i = 0; i < repository.length; ++i) {
                repository[i] = RepositoryMetaData.readFrom(in);
            }
            return new RepositoriesMetaData(repository);
        }

        @Override
        public void writeTo(RepositoriesMetaData repositories, StreamOutput out) throws IOException {
            out.writeVInt(repositories.repositories().size());
            for (RepositoryMetaData repository : repositories.repositories()) {
                repository.writeTo(out);
            }
        }

        @Override
        public RepositoriesMetaData fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token;
            ArrayList<RepositoryMetaData> repository = new ArrayList<RepositoryMetaData>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String name = parser.currentName();
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchParseException("failed to parse repository [" + name + "], expected object");
                    }
                    String type = null;
                    Settings settings = ImmutableSettings.EMPTY;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            String currentFieldName = parser.currentName();
                            if ("type".equals(currentFieldName)) {
                                if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                                    throw new ElasticsearchParseException("failed to parse repository [" + name + "], unknown type");
                                }
                                type = parser.text();
                                continue;
                            }
                            if ("settings".equals(currentFieldName)) {
                                if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                                    throw new ElasticsearchParseException("failed to parse repository [" + name + "], incompatible params");
                                }
                                settings = ImmutableSettings.settingsBuilder().put(SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered())).build();
                                continue;
                            }
                            throw new ElasticsearchParseException("failed to parse repository [" + name + "], unknown field [" + currentFieldName + "]");
                        }
                        throw new ElasticsearchParseException("failed to parse repository [" + name + "]");
                    }
                    if (type == null) {
                        throw new ElasticsearchParseException("failed to parse repository [" + name + "], missing repository type");
                    }
                    repository.add(new RepositoryMetaData(name, type, settings));
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse repositories");
            }
            return new RepositoriesMetaData(repository.toArray(new RepositoryMetaData[repository.size()]));
        }

        @Override
        public void toXContent(RepositoriesMetaData customIndexMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (RepositoryMetaData repository : customIndexMetaData.repositories()) {
                this.toXContent(repository, builder, params);
            }
        }

        @Override
        public EnumSet<MetaData.XContentContext> context() {
            return MetaData.API_AND_GATEWAY;
        }

        @Override
        public void toXContent(RepositoryMetaData repository, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(repository.name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("type", repository.type());
            builder.startObject("settings");
            for (Map.Entry settingEntry : repository.settings().getAsMap().entrySet()) {
                builder.field((String)settingEntry.getKey(), (String)settingEntry.getValue());
            }
            builder.endObject();
            builder.endObject();
        }
    }
}

