/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class IndexReplicationOperationRequest<T extends IndexReplicationOperationRequest>
extends ActionRequest<T>
implements IndicesRequest {
    private final TimeValue timeout;
    private final String index;
    private final ReplicationType replicationType;
    private final WriteConsistencyLevel consistencyLevel;
    private final OriginalIndices originalIndices;

    protected IndexReplicationOperationRequest(String index, TimeValue timeout, ReplicationType replicationType, WriteConsistencyLevel consistencyLevel, String[] originalIndices, IndicesOptions originalIndicesOptions, ActionRequest request) {
        super(request);
        this.index = index;
        this.timeout = timeout;
        this.replicationType = replicationType;
        this.consistencyLevel = consistencyLevel;
        this.originalIndices = new OriginalIndices(originalIndices, originalIndicesOptions);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public String index() {
        return this.index;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public final void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("IndexReplicationOperationRequest is not supposed to be sent over the transport");
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("IndexReplicationOperationRequest is not supposed to be sent over the transport");
    }
}

