/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.AlreadyImportedException;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.ImportFailedException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.domain.NothingToImportException;
import com.xebialabs.xltest.domain.Qualification;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.domain.TestToolNameAware;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.service.EventRepository;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Importer {
    private static final Logger LOG = LoggerFactory.getLogger(Importer.class);
    private final TestToolRepository testToolRepository;
    private final TestRunsRepository testRunsRepository;
    private final EventRepository eventRepository;

    @Autowired
    public Importer(TestToolRepository testToolRepository, TestRunsRepository testRunsRepository, EventRepository eventRepository) {
        this.testToolRepository = testToolRepository;
        this.testRunsRepository = testRunsRepository;
        this.eventRepository = eventRepository;
    }

    public void importLatestResults(BaseTestSpecification testSpecification, UUID testRunId, OverthereFile resultsSearchRoot, EventHandler eventHandler) throws ImportException {
        LOG.debug("importLatestResults(spec={}, testRunId={} )", (Object)testSpecification.getName(), (Object)testRunId);
        if (!(testSpecification instanceof TestToolNameAware)) {
            throw new IllegalArgumentException("Can only import results from test specifications that are TestToolNameAware!");
        }
        TestToolNameAware testToolNameAware = (TestToolNameAware)((Object)testSpecification);
        TestTool testTool = this.testToolRepository.findByName(testToolNameAware.getTestToolName());
        FileMatcher fileMatcher = new FileMatcher("**/*");
        this.importLatestResults(testSpecification, testTool, testRunId, resultsSearchRoot, fileMatcher, eventHandler);
    }

    public void importLatestResults(ActiveTestSpecification testSpecification, UUID testRunId, OverthereFile resultsSearchRoot, EventHandler eventHandler) throws ImportException {
        LOG.debug("importLatestResults(spec={}, testRunId={} )", (Object)testSpecification.getName(), (Object)testRunId);
        TestTool testTool = this.testToolRepository.findByName(testSpecification.getTestToolName());
        FileMatcher fileMatcher = new FileMatcher(testSpecification.getSearchPattern());
        this.importLatestResults(testSpecification, testTool, testRunId, resultsSearchRoot, fileMatcher, eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importLatestResults(BaseTestSpecification testSpecification, TestTool testTool, UUID testRunId, OverthereFile resultsSearchRoot, FileMatcher fileMatcher, EventHandler eventHandler) throws ImportException {
        LOG.debug("importLatestResults({})", (Object)testSpecification.getName());
        try {
            Importable importable = testTool.findLatestImportable(resultsSearchRoot, fileMatcher);
            Qualification qualification = this.getQualification(testSpecification, testTool.getCategory());
            LOG.debug("Found {} importable to import", (Object)(importable != null ? "an" : "no"));
            if (importable == null) {
                throw new NothingToImportException("No test results have been found");
            }
            try {
                this.performImport(testRunId, importable, testSpecification, qualification, eventHandler);
            }
            catch (ImportException e) {
                LOG.info("Latest results already seem present in XL test");
                throw e;
            }
            catch (Exception e) {
                LOG.error("Unable to import test run {}", (Object)importable, (Object)e);
                throw new ImportFailedException((Throwable)e);
            }
        }
        finally {
            if (resultsSearchRoot != null) {
                resultsSearchRoot.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importAllAvailableResults(ActiveTestSpecification testSpecification, OverthereFile resultsSearchRoot, EventHandler eventHandler, ImportProgressCallback progressCallback) throws ImportException {
        try {
            TestTool testTool = this.testToolRepository.findByName(testSpecification.getTestToolName());
            List<Importable> importables = testTool.findImportables(resultsSearchRoot, new FileMatcher(testSpecification.getSearchPattern()));
            Qualification qualification = this.getQualification(testSpecification, testTool.getCategory());
            int counter = 0;
            LOG.debug("Found {} importables to import", (Object)importables.size());
            for (Importable importable : importables) {
                UUID testRunId = UUID.randomUUID();
                try {
                    this.performImport(testRunId, importable, testSpecification, qualification, eventHandler);
                    counter = this.updateProgress(progressCallback, counter, importables.size());
                }
                catch (ImportException e) {
                    LOG.info("Results already seem present in XL test");
                    throw e;
                }
                catch (Exception e) {
                    LOG.error("Unable to import test run {}", (Object)importable, (Object)e);
                    throw new ImportFailedException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            if (resultsSearchRoot != null) {
                resultsSearchRoot.getConnection().close();
            }
        }
    }

    private void performImport(UUID testRunId, Importable importable, BaseTestSpecification testSpecification, Qualification qualification, EventHandler eventHandler) throws Exception {
        LOG.debug("performImport({},{})", (Object)testRunId, (Object)importable);
        Qualifier qualifier = qualification.getQualifier(testRunId, this.testRunsRepository);
        TestSpecificationSettingEventHandler innerEventHandler = new TestSpecificationSettingEventHandler(testSpecification, qualifier, eventHandler);
        importable.doImport(testRunId, (EventHandler)innerEventHandler);
        innerEventHandler.onReceive(qualifier.getEvent());
    }

    public Qualification getQualification(BaseTestSpecification testSpecification, String testToolCategory) {
        LOG.debug("getQualification({},{})", (Object)testSpecification.getName(), (Object)testToolCategory);
        if (testSpecification.getQualificationType() == null) {
            String defaultQualificationType;
            switch (testToolCategory) {
                case "functional": {
                    defaultQualificationType = "xlt.DefaultFunctionalTestsQualifier";
                    break;
                }
                case "performance": {
                    defaultQualificationType = "xlt.DefaultPerformanceTestsQualifier";
                    break;
                }
                default: {
                    throw new RuntimeException("Testtool not correctly configured or case not implemented. " + testToolCategory + " does not exist");
                }
            }
            return Qualification.getQualificationFor(defaultQualificationType);
        }
        return testSpecification.getQualification();
    }

    private int updateProgress(ImportProgressCallback progressCallback, int counter, int total) {
        if (progressCallback != null) {
            int percentage = ++counter * 100 / (total + 1);
            progressCallback.update(percentage);
        }
        return counter;
    }

    public static interface ImportProgressCallback {
        public void update(int var1);
    }

    class TestSpecificationSettingEventHandler
    implements EventHandler {
        private final BaseTestSpecification testSpecification;
        private final Qualifier qualifier;
        private final EventHandler eventHandler;

        public TestSpecificationSettingEventHandler(BaseTestSpecification testSpecification, Qualifier qualifier, EventHandler eventHandler) {
            this.testSpecification = testSpecification;
            this.qualifier = qualifier;
            this.eventHandler = eventHandler;
        }

        public void onReceive(Event event) throws Exception {
            this.importIsNew(event);
            LOG.trace("Importing event {}", (Object)event);
            Event updatedEvent = new Event(event, Event.props((Object[])new Object[]{"testSpecification", this.testSpecification.getName()}));
            this.qualifier.update(updatedEvent);
            this.eventHandler.onReceive(updatedEvent);
        }

        private void importIsNew(Event event) throws AlreadyImportedException {
            if ("importStarted".equals(event.getType())) {
                LOG.debug("Checking if importIsNew with fileName={} lastModified={} testSpecName={}", new Object[]{event.getFileName(), event.getLastModified(), this.testSpecification.getName()});
                Event matchingEvent = Importer.this.eventRepository.fetchLatest(String.format("type:\"%s\" AND fileName:\"%s\" AND lastModified:%d AND testSpecification:\"%s\"", event.getType(), event.getRequired("fileName"), event.getRequired("lastModified"), this.testSpecification.getName()));
                if (matchingEvent != null) {
                    throw new AlreadyImportedException(matchingEvent, event);
                }
            }
        }
    }
}

