/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xltest.utils.JcrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/data")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class DataController {
    private static final Logger LOG = LoggerFactory.getLogger((String)DataController.class.getName());
    private RepositoryService repository;
    private Validator validator;

    @Autowired
    public DataController(RepositoryService repository, Validator validator) {
        this.repository = repository;
        this.validator = validator;
    }

    @GET
    @Path(value="/")
    public Collection<BaseConfigurationItem> getAll(@QueryParam(value="type") String type) {
        SearchParameters query = new SearchParameters();
        if (type != null) {
            query.setType(Type.valueOf((String)type));
        }
        List baseConfigurationItems = this.repository.listEntities(query);
        return baseConfigurationItems;
    }

    @GET
    @Path(value="/{id:.+}")
    public BaseConfigurationItem get(@PathParam(value="id") String id) {
        LOG.info("reading item with id: " + id);
        return (BaseConfigurationItem)this.repository.read(id);
    }

    @PUT
    @Path(value="/{id:.+}")
    public Response update(@PathParam(value="id") String id, BaseConfigurationItem item) {
        LOG.info("update item with id: " + item.getId());
        if (id.equals(item.getId())) {
            for (PropertyDescriptor propertyDescriptor : item.getType().getDescriptor().getPropertyDescriptors()) {
                String name = propertyDescriptor.getName();
                Object propertyValue = propertyDescriptor.get((ConfigurationItem)item);
                LOG.info("set property " + name + " to value: " + propertyValue);
            }
            this.repository.createOrUpdate((ConfigurationItem[])new BaseConfigurationItem[]{item});
            return Response.status((int)201).entity((Object)item).build();
        }
        return Response.status((int)409).entity((Object)item).build();
    }

    @POST
    @Path(value="/")
    public Response create(BaseConfigurationItem item) {
        LOG.info("create item with id: {}", (Object)item.getId());
        JcrUtils.addPrefixIfNeeded((ConfigurationItem)item);
        JcrUtils.validateJcrId((ConfigurationItem)item);
        ArrayList<ConfigurationItem> toBeCreatedItems = new ArrayList<ConfigurationItem>();
        toBeCreatedItems.add((ConfigurationItem)item);
        this.searchForNestedToBeCreatedCis((ConfigurationItem)item, toBeCreatedItems);
        this.validator.validateCi((ConfigurationItem)item);
        try {
            this.repository.create(toBeCreatedItems.toArray(new ConfigurationItem[toBeCreatedItems.size()]));
            return Response.status((int)201).entity((Object)item).build();
        }
        catch (ItemAlreadyExistsException e) {
            return Response.status((int)409).entity((Object)item).build();
        }
    }

    @GET
    @Path(value="/move/{id:.+}")
    public Response move(@PathParam(value="id") String id, @QueryParam(value="newId") String newId) {
        this.repository.move(id, newId);
        return Response.status((int)204).build();
    }

    private void searchForNestedToBeCreatedCis(ConfigurationItem item, List<ConfigurationItem> toBeCreatedCis) {
        for (PropertyDescriptor property : item.getType().getDescriptor().getPropertyDescriptors()) {
            ConfigurationItem child;
            if (property.getKind() != PropertyKind.CI || (child = (ConfigurationItem)item.getProperty(property.getName())) == null || this.repository.exists(child.getId())) continue;
            toBeCreatedCis.add(0, child);
            this.searchForNestedToBeCreatedCis(child, toBeCreatedCis);
        }
    }

    @DELETE
    @Path(value="/{id:.+}")
    @Consumes(value={"*/*"})
    public Response delete(@PathParam(value="id") String id) {
        LOG.info("delete item with id: " + id);
        this.repository.delete(new String[]{id});
        return Response.ok().build();
    }
}

