/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.parser.Symbol;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WikiWordReference {
    private WikiPage currentPage;
    private String wikiWord;

    public WikiWordReference(WikiPage currentPage, String wikiWord) {
        this.currentPage = currentPage;
        this.wikiWord = wikiWord;
    }

    public WikiPage getReferencedPage() {
        String theWord = this.expandPrefix(this.wikiWord);
        WikiPage parentPage = this.currentPage.getParent();
        return parentPage.getPageCrawler().getPage(PathParser.parse(theWord));
    }

    private String expandPrefix(String theWord) {
        if (theWord.charAt(0) == '^' || theWord.charAt(0) == '>') {
            String prefix = this.currentPage.getName();
            return String.format("%s.%s", prefix, theWord.substring(1));
        }
        if (theWord.charAt(0) == '<') {
            String undecoratedPath = theWord.substring(1);
            String[] pathElements = undecoratedPath.split("\\.");
            String target = pathElements[0];
            WikiPage current = this.currentPage.getParent();
            while (!current.isRoot()) {
                if (current.getName().equals(target)) {
                    pathElements[0] = PathParser.render(current.getPageCrawler().getFullPath());
                    return "." + StringUtils.join(Arrays.asList(pathElements), ".");
                }
                current = current.getParent();
            }
            return "." + undecoratedPath;
        }
        return theWord;
    }

    public void wikiWordRenameMovedPageIfReferenced(Symbol wikiWord, WikiPage pageToBeMoved, String newParentName) {
        WikiPagePath pathOfPageToBeMoved = pageToBeMoved.getPageCrawler().getFullPath();
        pathOfPageToBeMoved.makeAbsolute();
        String qualifiedNameOfPageToBeMoved = PathParser.render(pathOfPageToBeMoved);
        String reference = this.getQualifiedWikiWord(wikiWord.getContent());
        if (this.refersTo(reference, qualifiedNameOfPageToBeMoved)) {
            String referenceTail = reference.substring(qualifiedNameOfPageToBeMoved.length());
            String childPortionOfReference = pageToBeMoved.getName();
            if (!referenceTail.isEmpty()) {
                childPortionOfReference = childPortionOfReference + referenceTail;
            }
            String newQualifiedName = "".equals(newParentName) ? "." + childPortionOfReference : "." + newParentName + "." + childPortionOfReference;
            wikiWord.setContent(newQualifiedName);
        }
    }

    private String getQualifiedWikiWord(String wikiWordText) {
        String pathName = this.expandPrefix(wikiWordText);
        WikiPagePath expandedPath = PathParser.parse(pathName);
        if (expandedPath == null) {
            return wikiWordText;
        }
        WikiPagePath fullPath = this.currentPage.getParent().getPageCrawler().getFullPathOfChild(expandedPath);
        return "." + PathParser.render(fullPath);
    }

    private boolean refersTo(String qualifiedReference, String qualifiedTarget) {
        return qualifiedReference.equals(qualifiedTarget) || qualifiedReference.startsWith(qualifiedTarget + ".");
    }

    public void wikiWordRenamePageIfReferenced(Symbol wikiWord, WikiPage pageToRename, String newName) throws Exception {
        String fullPathToReferent = this.getQualifiedWikiWord(wikiWord.getContent());
        WikiPagePath pathToPageBeingRenamed = pageToRename.getPageCrawler().getFullPath();
        pathToPageBeingRenamed.makeAbsolute();
        String absolutePathToPageBeingRenamed = PathParser.render(pathToPageBeingRenamed);
        if (this.refersTo(fullPathToReferent, absolutePathToPageBeingRenamed)) {
            int oldNameLength = absolutePathToPageBeingRenamed.length();
            String renamedPath = "." + this.rename(absolutePathToPageBeingRenamed.substring(1), newName);
            String pathAfterRenamedPage = fullPathToReferent.substring(oldNameLength);
            String fullRenamedPathToReferent = renamedPath + pathAfterRenamedPage;
            String renamedReference = this.makeRenamedRelativeReference(wikiWord.getContent(), PathParser.parse(fullRenamedPathToReferent));
            wikiWord.setContent(renamedReference);
        }
    }

    private String rename(String oldQualifiedName, String newPageName) {
        int lastDotIndex = oldQualifiedName.lastIndexOf(".");
        String newQualifiedName = lastDotIndex < 1 ? newPageName : oldQualifiedName.substring(0, lastDotIndex + 1) + newPageName;
        return newQualifiedName;
    }

    private String makeRenamedRelativeReference(String wikiWordText, WikiPagePath renamedPathToReferent) throws Exception {
        WikiPage parent = this.currentPage.getParent();
        WikiPagePath parentPath = parent.getPageCrawler().getFullPath();
        parentPath.makeAbsolute();
        if (wikiWordText.startsWith(".")) {
            return PathParser.render(renamedPathToReferent);
        }
        if (wikiWordText.startsWith("<")) {
            return this.buildBackwardSearchReference(parentPath, renamedPathToReferent);
        }
        boolean parentPathNotRenamed = renamedPathToReferent.startsWith(parentPath);
        if (parentPathNotRenamed) {
            WikiPagePath relativePath = renamedPathToReferent.subtractFromFront(parentPath);
            if (wikiWordText.startsWith("^") || wikiWordText.startsWith(">")) {
                return ">" + PathParser.render(relativePath.getRest());
            }
            return PathParser.render(relativePath);
        }
        return wikiWordText;
    }

    private String buildBackwardSearchReference(WikiPagePath parentPath, WikiPagePath renamedPathToReferent) {
        int branchPoint = this.findBranchPoint(parentPath.getNames(), renamedPathToReferent.getNames());
        List<String> referentPath = renamedPathToReferent.getNames();
        List<String> referentPathAfterBranchPoint = referentPath.subList(branchPoint, referentPath.size());
        return "<" + StringUtils.join(referentPathAfterBranchPoint, ".");
    }

    private int findBranchPoint(List<String> list1, List<String> list2) {
        int i;
        for (i = 0; i < list1.size() && list1.get(i).equals(list2.get(i)); ++i) {
        }
        return Math.max(0, i - 1);
    }
}

