/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.responders.testHistory.SuiteOverviewTree;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.SuiteFilter;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;

public class SuiteOverviewResponder
implements Responder {
    private FitNesseContext context;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        WikiPage root = context.getRootPage();
        WikiPage page = root.getPageCrawler().getPage(PathParser.parse(request.getResource()));
        SuiteFilter filter = SuiteResponder.createSuiteFilter(request, page.getPageCrawler().getFullPath().toString());
        SuiteContentsFinder suiteTestFinder = new SuiteContentsFinder(page, filter, root);
        List<WikiPage> pagelist = suiteTestFinder.getAllPagesToRunForThisSuite();
        SuiteOverviewTree treeview = new SuiteOverviewTree(pagelist);
        treeview.findLatestResults(context.getTestHistoryDirectory());
        treeview.countResults();
        WikiPagePath path = PathParser.parse(request.getResource());
        SimpleResponse response = this.makeResponse(treeview, path, request);
        return response;
    }

    private SimpleResponse makeResponse(SuiteOverviewTree treeview, WikiPagePath path, Request request) {
        SimpleResponse response = new SimpleResponse();
        HtmlPage page = this.context.pageFactory.newPage();
        page.setTitle("Suite Overview");
        page.setPageTitle(new PageTitle("Suite Overview", path));
        page.put("treeRoot", treeview.getTreeRoot());
        page.put("viewLocation", request.getResource());
        page.setMainTemplate("suiteOverview");
        response.setContent(page.html());
        return response;
    }
}

