/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.license.License;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.service.AbstractLicenseService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseServiceImpl
extends AbstractLicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);

    public LicenseServiceImpl(String licensePath, String product) throws IOException {
        this(licensePath, product, "1");
    }

    public LicenseServiceImpl(String licensePath, String product, String minimumLicenseVersion) throws IOException {
        super(licensePath, product, minimumLicenseVersion);
        if (!this.licenseFile.exists()) {
            this.logLicenseError(this.licenseFile);
            throw new FileNotFoundException("License can not be found at " + this.licenseFile.getAbsolutePath());
        }
        this.license = this.readLicense(this.licenseFile);
        if (this.license.isDateExpired()) {
            this.logLicenseError(this.licenseFile);
        }
        if (!this.license.isAtLeastVersion(minimumLicenseVersion)) {
            this.logLicenseVersionError(this.license, minimumLicenseVersion);
        }
    }

    @Override
    protected License readLicense(File licenseFile) {
        String licenseFilePath = licenseFile.getAbsolutePath();
        log.info("Reading license from file {}", (Object)licenseFilePath);
        License license = LicenseReader.readLicense(licenseFile);
        log.info(license.toLicenseContent());
        if (license.isDateExpired()) {
            log.warn("*** License has expired.");
        }
        return license;
    }
}

