/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.base.Joiner;
import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.LicenseProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LicensePropertyMap {
    public static final DateTimeFormatter LICENSE_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private Map<LicenseProperty, Object> licenseProperties = new HashMap<LicenseProperty, Object>();

    public void set(LicenseProperty prop, String value) {
        if (value == null || value.trim().isEmpty()) {
            return;
        }
        switch (prop.getType()) {
            case STRING: {
                this.licenseProperties.put(prop, value);
                break;
            }
            case DATE: {
                try {
                    this.licenseProperties.put(prop, LocalDate.parse((String)value, (DateTimeFormatter)LICENSE_DATE_FORMAT));
                    break;
                }
                catch (Exception e) {
                    throw new InvalidLicenseException(String.format("Unable to parse '%s' '%s'", prop.getName().toLowerCase(), value));
                }
            }
            case MAP_STRING_INTEGER: {
                Map msi = (Map)this.get(prop);
                try {
                    String[] pairStringInt = value.trim().split("=");
                    Integer intValue = Integer.parseInt(pairStringInt[1].trim());
                    String stringValue = pairStringInt[0].trim();
                    msi.put(stringValue, intValue);
                    break;
                }
                catch (Exception e) {
                    throw new InvalidLicenseException(String.format("Unable to parse '%s' '%s'", prop.getName().toLowerCase(), value));
                }
            }
            case LIST_OF_STRINGS: {
                List set = (List)this.get(prop);
                set.add(value);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown License property type " + (Object)((Object)prop.getType()));
            }
        }
    }

    public <T> T get(LicenseProperty prop) {
        switch (prop.getType()) {
            case STRING: 
            case DATE: {
                return (T)this.licenseProperties.get((Object)prop);
            }
            case MAP_STRING_INTEGER: {
                if (!this.licenseProperties.containsKey((Object)prop)) {
                    this.licenseProperties.put(prop, new LinkedHashMap());
                }
                return (T)this.licenseProperties.get((Object)prop);
            }
            case LIST_OF_STRINGS: {
                if (!this.licenseProperties.containsKey((Object)prop)) {
                    this.licenseProperties.put(prop, new ArrayList());
                }
                return (T)this.licenseProperties.get((Object)prop);
            }
        }
        throw new IllegalStateException("Unknown License property type " + (Object)((Object)prop.getType()));
    }

    public String getAsString(LicenseProperty prop) {
        switch (prop.getType()) {
            case STRING: {
                return (String)this.get(prop);
            }
            case DATE: {
                return LICENSE_DATE_FORMAT.print((ReadablePartial)((LocalDate)this.get(prop)));
            }
            case MAP_STRING_INTEGER: {
                Map msi = (Map)this.get(prop);
                if (msi.isEmpty()) {
                    return null;
                }
                StringBuilder b = new StringBuilder();
                for (Map.Entry entry : msi.entrySet()) {
                    if (b.length() != 0) {
                        b.append(",");
                    }
                    b.append((String)entry.getKey()).append("=").append(entry.getValue());
                }
                return b.toString();
            }
            case LIST_OF_STRINGS: {
                return Joiner.on((String)",").join((Iterable)this.get(prop));
            }
        }
        throw new IllegalStateException("Unknown License property type " + (Object)((Object)prop.getType()));
    }

    boolean containsKey(LicenseProperty prop) {
        return this.licenseProperties.containsKey((Object)prop);
    }

    void format(StringBuilder collector, String template, LicenseProperty prop) {
        if (this.containsKey(prop)) {
            switch (prop.getType()) {
                case STRING: 
                case DATE: {
                    collector.append(String.format(template, prop.getName(), this.licenseProperties.get((Object)prop)));
                    break;
                }
                case MAP_STRING_INTEGER: {
                    Map msi = (Map)this.get(prop);
                    for (String s : msi.keySet()) {
                        collector.append(String.format(template, prop.getName(), s + "=" + msi.get(s)));
                    }
                    break;
                }
                case LIST_OF_STRINGS: {
                    List ss = (List)this.get(prop);
                    for (String s : ss) {
                        collector.append(String.format(template, prop.getName(), s));
                    }
                    break;
                }
            }
        }
    }
}

