/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.codec.serialization;

import org.python.netty.buffer.ByteBuf;
import org.python.netty.buffer.ByteBufInputStream;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.python.netty.handler.codec.serialization.ClassResolver;
import org.python.netty.handler.codec.serialization.CompactObjectInputStream;

public class ObjectDecoder
extends LengthFieldBasedFrameDecoder {
    private final ClassResolver classResolver;

    public ObjectDecoder(ClassResolver classResolver) {
        this(0x100000, classResolver);
    }

    public ObjectDecoder(int maxObjectSize, ClassResolver classResolver) {
        super(maxObjectSize, 0, 4, 0, 4);
        this.classResolver = classResolver;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            return null;
        }
        CompactObjectInputStream is = new CompactObjectInputStream(new ByteBufInputStream(frame), this.classResolver);
        Object result2 = is.readObject();
        is.close();
        return result2;
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

