/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GracefulNamer {
    private static final Pattern disgracefulNamePattern = Pattern.compile("\\w(?:[.]|\\w)*[^.]");
    private StringBuffer finalName = new StringBuffer();
    private GracefulNameState currentState = new OutOfWordState();

    public static boolean isGracefulName(String fixtureName) {
        Matcher matcher = disgracefulNamePattern.matcher(fixtureName);
        return !matcher.matches();
    }

    public static String disgrace(String fixtureName) {
        GracefulNamer namer = new GracefulNamer();
        for (int i = 0; i < fixtureName.length(); ++i) {
            char c = fixtureName.charAt(i);
            if (Character.isLetter(c)) {
                namer.currentState.letter(c);
                continue;
            }
            if (Character.isDigit(c)) {
                namer.currentState.digit(c);
                continue;
            }
            namer.currentState.other(c);
        }
        return namer.finalName.toString();
    }

    public static String regrace(String disgracefulName) {
        int separator = 46;
        char c = '?';
        GracefulNamer namer = new GracefulNamer();
        if (!disgracefulName.isEmpty()) {
            char c2 = disgracefulName.charAt(0);
            c = c2;
            namer.finalName.append(c2);
        }
        boolean isGrabbingDigits = false;
        boolean wasSeparator = c == '.' || c == '<' || c == '>';
        for (int i = 1; i < disgracefulName.length(); ++i) {
            c = disgracefulName.charAt(i);
            if (Character.isUpperCase(c) || Character.isDigit(c) && !isGrabbingDigits || c == '.') {
                if (!wasSeparator) {
                    namer.finalName.append(" ");
                }
                wasSeparator = c == '.';
            }
            isGrabbingDigits = Character.isDigit(c);
            namer.finalName.append(c);
        }
        return namer.finalName.toString();
    }

    private GracefulNamer() {
    }

    private class OutOfWordState
    implements GracefulNameState {
        private OutOfWordState() {
        }

        @Override
        public void letter(char c) {
            GracefulNamer.this.finalName.append(Character.toUpperCase(c));
            GracefulNamer.this.currentState = new InWordState();
        }

        @Override
        public void digit(char c) {
            GracefulNamer.this.finalName.append(c);
            GracefulNamer.this.currentState = new InNumberState();
        }

        @Override
        public void other(char c) {
        }
    }

    private class InNumberState
    implements GracefulNameState {
        private InNumberState() {
        }

        @Override
        public void letter(char c) {
            GracefulNamer.this.finalName.append(Character.toUpperCase(c));
            GracefulNamer.this.currentState = new InWordState();
        }

        @Override
        public void digit(char c) {
            GracefulNamer.this.finalName.append(c);
        }

        @Override
        public void other(char c) {
            GracefulNamer.this.currentState = new OutOfWordState();
        }
    }

    private class InWordState
    implements GracefulNameState {
        private InWordState() {
        }

        @Override
        public void letter(char c) {
            GracefulNamer.this.finalName.append(c);
        }

        @Override
        public void digit(char c) {
            GracefulNamer.this.finalName.append(c);
            GracefulNamer.this.currentState = new InNumberState();
        }

        @Override
        public void other(char c) {
            GracefulNamer.this.currentState = new OutOfWordState();
        }
    }

    private static interface GracefulNameState {
        public void letter(char var1);

        public void digit(char var1);

        public void other(char var1);
    }
}

