/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import fitnesse.slim.converters.ListConverterHelper;
import fitnesse.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

public class GenericCollectionConverter<T, C extends Collection<T>>
implements Converter<C> {
    public static final Map<Class<?>, Class<?>> DEFAULT_COLLECTION_IMPL = new HashMap();
    private final Class<C> collectionClass;
    private final Converter<T> componentConverter;

    public GenericCollectionConverter(Class<?> collectionClass, Converter<T> componentConverter) {
        if (collectionClass.isInterface()) {
            collectionClass = DEFAULT_COLLECTION_IMPL.get(collectionClass);
        }
        this.collectionClass = collectionClass;
        this.componentConverter = componentConverter;
    }

    @Override
    public String toString(C collection) {
        if (collection == null) {
            return NULL_VALUE;
        }
        int size = collection.size();
        ArrayList<String> ret = new ArrayList<String>(size);
        for (Object item : collection) {
            ret.add(this.componentConverter.toString(item));
        }
        return ListConverterHelper.toString(ret);
    }

    @Override
    public C fromString(String arg) {
        Collection collection;
        if (StringUtils.isBlank(arg)) {
            return null;
        }
        try {
            collection = (Collection)this.collectionClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Collection should have a default constructor", e);
        }
        String[] strings = ListConverterHelper.fromStringToArrayOfStrings(arg);
        for (int i = 0; i < strings.length; ++i) {
            collection.add(this.componentConverter.fromString(strings[i]));
        }
        return (C)collection;
    }

    static {
        DEFAULT_COLLECTION_IMPL.put(List.class, ArrayList.class);
        DEFAULT_COLLECTION_IMPL.put(Set.class, HashSet.class);
        DEFAULT_COLLECTION_IMPL.put(Queue.class, PriorityQueue.class);
    }
}

