/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.breaker.ChildMemoryCircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.indices.breaker.AllCircuitBreakerStats;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;
import org.elasticsearch.node.settings.NodeSettingsService;

public class HierarchyCircuitBreakerService
extends CircuitBreakerService {
    private volatile ImmutableMap<CircuitBreaker.Name, CircuitBreaker> breakers;
    public static final String OLD_CIRCUIT_BREAKER_MAX_BYTES_SETTING = "indices.fielddata.breaker.limit";
    public static final String OLD_CIRCUIT_BREAKER_OVERHEAD_SETTING = "indices.fielddata.breaker.overhead";
    public static final String TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING = "indices.breaker.total.limit";
    public static final String DEFAULT_TOTAL_CIRCUIT_BREAKER_LIMIT = "70%";
    public static final String FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING = "indices.breaker.fielddata.limit";
    public static final String FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING = "indices.breaker.fielddata.overhead";
    public static final String FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING = "indices.breaker.fielddata.type";
    public static final String DEFAULT_FIELDDATA_BREAKER_LIMIT = "60%";
    public static final double DEFAULT_FIELDDATA_OVERHEAD_CONSTANT = 1.03;
    public static final String REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING = "indices.breaker.request.limit";
    public static final String REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING = "indices.breaker.request.overhead";
    public static final String REQUEST_CIRCUIT_BREAKER_TYPE_SETTING = "indices.breaker.request.type";
    public static final String DEFAULT_REQUEST_BREAKER_LIMIT = "40%";
    public static final String DEFAULT_BREAKER_TYPE = "memory";
    private volatile BreakerSettings parentSettings;
    private volatile BreakerSettings fielddataSettings;
    private volatile BreakerSettings requestSettings;
    private final AtomicLong parentTripCount = new AtomicLong(0L);

    @Inject
    public HierarchyCircuitBreakerService(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        String compatibilityFielddataLimitDefault = DEFAULT_FIELDDATA_BREAKER_LIMIT;
        ByteSizeValue compatibilityFielddataLimit = settings.getAsMemory(OLD_CIRCUIT_BREAKER_MAX_BYTES_SETTING, null);
        if (compatibilityFielddataLimit != null) {
            compatibilityFielddataLimitDefault = compatibilityFielddataLimit.toString();
        }
        double compatibilityFielddataOverheadDefault = 1.03;
        Double compatibilityFielddataOverhead = settings.getAsDouble(OLD_CIRCUIT_BREAKER_OVERHEAD_SETTING, null);
        if (compatibilityFielddataOverhead != null) {
            compatibilityFielddataOverheadDefault = compatibilityFielddataOverhead;
        }
        this.fielddataSettings = new BreakerSettings(CircuitBreaker.Name.FIELDDATA, settings.getAsMemory(FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING, compatibilityFielddataLimitDefault).bytes(), settings.getAsDouble(FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING, (Double)compatibilityFielddataOverheadDefault), CircuitBreaker.Type.parseValue(settings.get(FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING, DEFAULT_BREAKER_TYPE)));
        this.requestSettings = new BreakerSettings(CircuitBreaker.Name.REQUEST, settings.getAsMemory(REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING, DEFAULT_REQUEST_BREAKER_LIMIT).bytes(), settings.getAsDouble(REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING, (Double)1.0), CircuitBreaker.Type.parseValue(settings.get(REQUEST_CIRCUIT_BREAKER_TYPE_SETTING, DEFAULT_BREAKER_TYPE)));
        HierarchyCircuitBreakerService.validateSettings(new BreakerSettings[]{this.requestSettings, this.fielddataSettings});
        this.parentSettings = new BreakerSettings(CircuitBreaker.Name.PARENT, settings.getAsMemory(TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING, DEFAULT_TOTAL_CIRCUIT_BREAKER_LIMIT).bytes(), 1.0, CircuitBreaker.Type.PARENT);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("parent circuit breaker with settings {}", this.parentSettings);
        }
        HashMap<CircuitBreaker.Name, NoopCircuitBreaker> tempBreakers = new HashMap<CircuitBreaker.Name, NoopCircuitBreaker>();
        CircuitBreaker fielddataBreaker = this.fielddataSettings.getType() == CircuitBreaker.Type.NOOP ? new NoopCircuitBreaker(CircuitBreaker.Name.FIELDDATA) : new ChildMemoryCircuitBreaker(this.fielddataSettings, this.logger, this, CircuitBreaker.Name.FIELDDATA);
        CircuitBreaker requestBreaker = this.requestSettings.getType() == CircuitBreaker.Type.NOOP ? new NoopCircuitBreaker(CircuitBreaker.Name.REQUEST) : new ChildMemoryCircuitBreaker(this.requestSettings, this.logger, this, CircuitBreaker.Name.REQUEST);
        tempBreakers.put(CircuitBreaker.Name.FIELDDATA, (NoopCircuitBreaker)fielddataBreaker);
        tempBreakers.put(CircuitBreaker.Name.REQUEST, (NoopCircuitBreaker)requestBreaker);
        this.breakers = ImmutableMap.copyOf(tempBreakers);
        nodeSettingsService.addListener(new ApplySettings());
    }

    public static void validateSettings(BreakerSettings[] childrenSettings) throws ElasticsearchIllegalStateException {
        for (BreakerSettings childSettings : childrenSettings) {
            if (childSettings.getLimit() == -1L || !(childSettings.getOverhead() < 0.0)) continue;
            throw new ElasticsearchIllegalStateException("Child breaker overhead " + childSettings + " must be non-negative");
        }
    }

    @Override
    public CircuitBreaker getBreaker(CircuitBreaker.Name name) {
        return this.breakers.get((Object)name);
    }

    @Override
    public AllCircuitBreakerStats stats() {
        long parentEstimated = 0L;
        ArrayList<CircuitBreakerStats> allStats = Lists.newArrayList();
        for (CircuitBreaker breaker : this.breakers.values()) {
            allStats.add(this.stats(breaker.getName()));
            parentEstimated += breaker.getUsed();
        }
        allStats.add(new CircuitBreakerStats(CircuitBreaker.Name.PARENT, this.parentSettings.getLimit(), parentEstimated, 1.0, this.parentTripCount.get()));
        return new AllCircuitBreakerStats(allStats.toArray(new CircuitBreakerStats[allStats.size()]));
    }

    @Override
    public CircuitBreakerStats stats(CircuitBreaker.Name name) {
        CircuitBreaker breaker = this.breakers.get((Object)name);
        return new CircuitBreakerStats(breaker.getName(), breaker.getLimit(), breaker.getUsed(), breaker.getOverhead(), breaker.getTrippedCount());
    }

    public void checkParentLimit(String label) throws CircuitBreakingException {
        long totalUsed = 0L;
        for (CircuitBreaker breaker : this.breakers.values()) {
            totalUsed = (long)((double)totalUsed + (double)breaker.getUsed() * breaker.getOverhead());
        }
        long parentLimit = this.parentSettings.getLimit();
        if (totalUsed > parentLimit) {
            this.parentTripCount.incrementAndGet();
            throw new CircuitBreakingException("[PARENT] Data too large, data for [" + label + "] would be larger than limit of [" + parentLimit + "/" + new ByteSizeValue(parentLimit) + "]", totalUsed, parentLimit);
        }
    }

    public class ApplySettings
    implements NodeSettingsService.Listener {
        @Override
        public void onRefreshSettings(Settings settings) {
            boolean changed = false;
            BreakerSettings newFielddataSettings = HierarchyCircuitBreakerService.this.fielddataSettings;
            ByteSizeValue newFielddataMax = settings.getAsMemory(HierarchyCircuitBreakerService.FIELDDATA_CIRCUIT_BREAKER_LIMIT_SETTING, null);
            Double newFielddataOverhead = settings.getAsDouble(HierarchyCircuitBreakerService.FIELDDATA_CIRCUIT_BREAKER_OVERHEAD_SETTING, null);
            if (newFielddataMax != null || newFielddataOverhead != null) {
                changed = true;
                long newFielddataLimitBytes = newFielddataMax == null ? HierarchyCircuitBreakerService.this.fielddataSettings.getLimit() : newFielddataMax.bytes();
                newFielddataOverhead = newFielddataOverhead == null ? HierarchyCircuitBreakerService.this.fielddataSettings.getOverhead() : newFielddataOverhead.doubleValue();
                newFielddataSettings = new BreakerSettings(CircuitBreaker.Name.FIELDDATA, newFielddataLimitBytes, newFielddataOverhead, HierarchyCircuitBreakerService.this.fielddataSettings.getType());
            }
            BreakerSettings newRequestSettings = HierarchyCircuitBreakerService.this.requestSettings;
            ByteSizeValue newRequestMax = settings.getAsMemory(HierarchyCircuitBreakerService.REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING, null);
            Double newRequestOverhead = settings.getAsDouble(HierarchyCircuitBreakerService.REQUEST_CIRCUIT_BREAKER_OVERHEAD_SETTING, null);
            if (newRequestMax != null || newRequestOverhead != null) {
                changed = true;
                long newRequestLimitBytes = newRequestMax == null ? HierarchyCircuitBreakerService.this.requestSettings.getLimit() : newRequestMax.bytes();
                newRequestOverhead = newRequestOverhead == null ? HierarchyCircuitBreakerService.this.requestSettings.getOverhead() : newRequestOverhead.doubleValue();
                newRequestSettings = new BreakerSettings(CircuitBreaker.Name.REQUEST, newRequestLimitBytes, newRequestOverhead, HierarchyCircuitBreakerService.this.requestSettings.getType());
            }
            BreakerSettings newParentSettings = HierarchyCircuitBreakerService.this.parentSettings;
            long oldParentMax = HierarchyCircuitBreakerService.this.parentSettings.getLimit();
            ByteSizeValue newParentMax = settings.getAsMemory(HierarchyCircuitBreakerService.TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING, null);
            if (newParentMax != null && newParentMax.bytes() != oldParentMax) {
                changed = true;
                newParentSettings = new BreakerSettings(CircuitBreaker.Name.PARENT, newParentMax.bytes(), 1.0, CircuitBreaker.Type.PARENT);
            }
            if (changed) {
                HierarchyCircuitBreakerService.validateSettings(new BreakerSettings[]{newFielddataSettings, newRequestSettings});
                HierarchyCircuitBreakerService.this.logger.info("Updating settings parent: {}, fielddata: {}, request: {}", newParentSettings, newFielddataSettings, newRequestSettings);
                HierarchyCircuitBreakerService.this.parentSettings = newParentSettings;
                HierarchyCircuitBreakerService.this.fielddataSettings = newFielddataSettings;
                HierarchyCircuitBreakerService.this.requestSettings = newRequestSettings;
                HashMap<CircuitBreaker.Name, NoopCircuitBreaker> tempBreakers = new HashMap<CircuitBreaker.Name, NoopCircuitBreaker>();
                CircuitBreaker fielddataBreaker = newFielddataSettings.getType() == CircuitBreaker.Type.NOOP ? new NoopCircuitBreaker(CircuitBreaker.Name.FIELDDATA) : new ChildMemoryCircuitBreaker(newFielddataSettings, (ChildMemoryCircuitBreaker)HierarchyCircuitBreakerService.this.breakers.get((Object)CircuitBreaker.Name.FIELDDATA), HierarchyCircuitBreakerService.this.logger, HierarchyCircuitBreakerService.this, CircuitBreaker.Name.FIELDDATA);
                CircuitBreaker requestBreaker = newRequestSettings.getType() == CircuitBreaker.Type.NOOP ? new NoopCircuitBreaker(CircuitBreaker.Name.REQUEST) : new ChildMemoryCircuitBreaker(newRequestSettings, (ChildMemoryCircuitBreaker)HierarchyCircuitBreakerService.this.breakers.get((Object)CircuitBreaker.Name.REQUEST), HierarchyCircuitBreakerService.this.logger, HierarchyCircuitBreakerService.this, CircuitBreaker.Name.REQUEST);
                tempBreakers.put(CircuitBreaker.Name.FIELDDATA, (NoopCircuitBreaker)fielddataBreaker);
                tempBreakers.put(CircuitBreaker.Name.REQUEST, (NoopCircuitBreaker)requestBreaker);
                HierarchyCircuitBreakerService.this.breakers = ImmutableMap.copyOf(tempBreakers);
            }
        }
    }
}

