/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.util.Locale;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public class FieldValueFactorFunction
extends ScoreFunction {
    private final String field;
    private final float boostFactor;
    private final Modifier modifier;
    private final IndexNumericFieldData indexFieldData;
    private SortedNumericDoubleValues values;

    public FieldValueFactorFunction(String field, float boostFactor, Modifier modifierType, IndexNumericFieldData indexFieldData) {
        super(CombineFunction.MULT);
        this.field = field;
        this.boostFactor = boostFactor;
        this.modifier = modifierType;
        this.indexFieldData = indexFieldData;
    }

    @Override
    public void setNextReader(AtomicReaderContext context) {
        this.values = ((AtomicNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
    }

    @Override
    public double score(int docId, float subQueryScore) {
        this.values.setDocument(docId);
        int numValues = this.values.count();
        if (numValues > 0) {
            double val = this.values.valueAt(0) * (double)this.boostFactor;
            double result = this.modifier.apply(val);
            if (Double.isNaN(result) || Double.isInfinite(result)) {
                throw new ElasticsearchException("Result of field modification [" + this.modifier.toString() + "(" + val + ")] must be a number");
            }
            return result;
        }
        throw new ElasticsearchException("Missing value for field [" + this.field + "]");
    }

    @Override
    public Explanation explainScore(int docId, float subQueryScore) {
        Explanation exp = new Explanation();
        String modifierStr = this.modifier != null ? this.modifier.toString() : "";
        double score = this.score(docId, subQueryScore);
        exp.setValue(CombineFunction.toFloat(score));
        exp.setDescription("field value function: " + modifierStr + "(" + "doc['" + this.field + "'].value * factor=" + this.boostFactor + ")");
        return exp;
    }

    public static enum Modifier {
        NONE{

            @Override
            public double apply(double n) {
                return n;
            }
        }
        ,
        LOG{

            @Override
            public double apply(double n) {
                return Math.log10(n);
            }
        }
        ,
        LOG1P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 1.0);
            }
        }
        ,
        LOG2P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 2.0);
            }
        }
        ,
        LN{

            @Override
            public double apply(double n) {
                return Math.log(n);
            }
        }
        ,
        LN1P{

            @Override
            public double apply(double n) {
                return Math.log1p(n);
            }
        }
        ,
        LN2P{

            @Override
            public double apply(double n) {
                return Math.log1p(n + 1.0);
            }
        }
        ,
        SQUARE{

            @Override
            public double apply(double n) {
                return Math.pow(n, 2.0);
            }
        }
        ,
        SQRT{

            @Override
            public double apply(double n) {
                return Math.sqrt(n);
            }
        }
        ,
        RECIPROCAL{

            @Override
            public double apply(double n) {
                return 1.0 / n;
            }
        };


        public abstract double apply(double var1);

        public String toString() {
            if (this == NONE) {
                return "";
            }
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

