/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class SecretKeyHolder {
    private static final AtomicReference<SecretKeyHolder> instance = new AtomicReference();
    private final SecretKey secretKey;

    public static void init(SecretKey key) {
        instance.set(new SecretKeyHolder(key));
    }

    public static void reset() {
        instance.set(null);
    }

    public static SecretKeyHolder get() {
        SecretKeyHolder encryptionKeyHolder = instance.get();
        Preconditions.checkState((encryptionKeyHolder != null ? 1 : 0) != 0, (Object)"EncryptionKeyHolder not yet set, please construct one.");
        return encryptionKeyHolder;
    }

    public SecretKeyHolder(SecretKey secretKey) {
        Preconditions.checkNotNull((Object)secretKey, (Object)"secretKey cannot be null");
        this.secretKey = secretKey;
    }

    public String getKeyFingerprint() {
        byte[] bytes = JavaCryptoUtils.getSha1().digest(this.secretKey.getEncoded());
        return BaseEncoding.base16().lowerCase().encode(bytes);
    }

    public Cipher getEncryption() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        return this.getCipher(1);
    }

    public Cipher getDecryption() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        return this.getCipher(2);
    }

    private Cipher getCipher(int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher aes = Cipher.getInstance(this.secretKey.getAlgorithm());
        aes.init(mode, this.secretKey);
        return aes;
    }
}

