/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.statistic;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.math.MathOperations;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.StringUtil;

@ThreadSafe
public class SimpleStatistics<T extends Number> {
    protected final MathOperations<T> math;
    private int count = 0;
    private T total;
    private T maximum;
    private T minimum;
    private T mean;
    private Double meanValue;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public SimpleStatistics(MathOperations<T> operations) {
        this.math = operations;
        this.total = (Number)this.math.createZeroValue();
        this.maximum = (Number)this.math.createZeroValue();
        this.minimum = null;
        this.mean = (Number)this.math.createZeroValue();
        this.meanValue = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T value) {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.doAddValue(value);
        }
        finally {
            lock.unlock();
        }
    }

    protected void doAddValue(T value) {
        if (value == null) {
            return;
        }
        ++this.count;
        this.total = (Number)this.math.add(this.total, value);
        this.maximum = (Number)this.math.maximum(this.maximum, value);
        this.minimum = (Number)this.math.minimum(this.minimum, value);
        int count = this.getCount();
        if (count == 1) {
            this.meanValue = ((Number)value).doubleValue();
            this.mean = value;
        } else {
            double dValue = ((Number)value).doubleValue();
            double dCount = count;
            this.meanValue = this.meanValue + (dValue - this.meanValue) / dCount;
            this.mean = (Number)this.math.create(this.meanValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getTotal() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            T t = this.total;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getMaximum() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            T t = this.maximum;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getMinimum() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            T t = this.minimum != null ? this.minimum : (Number)this.math.createZeroValue();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getMean() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            T t = this.mean;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMeanValue() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            double d = this.meanValue;
            return d;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.doReset();
        }
        finally {
            lock.unlock();
        }
    }

    public MathOperations<T> getMathOperations() {
        return this.math;
    }

    protected ReadWriteLock getLock() {
        return this.lock;
    }

    protected void doReset() {
        this.total = (Number)this.math.createZeroValue();
        this.maximum = (Number)this.math.createZeroValue();
        this.minimum = null;
        this.mean = (Number)this.math.createZeroValue();
        this.meanValue = 0.0;
        this.count = 0;
    }

    public String toString() {
        int count = this.getCount();
        String samples = Inflector.getInstance().pluralize("sample", count);
        return StringUtil.createString("{0} {1}: min={2}; avg={3}; max={4}", count, samples, this.minimum, this.mean, this.maximum);
    }
}

