/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.Tag;
import com.xebialabs.xltest.repository.TagsRepository;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/tags")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class TagController {
    private static final Logger LOG = LoggerFactory.getLogger((String)TagController.class.getName());
    private final TagsRepository tagsRepository;

    @Autowired
    public TagController(TagsRepository tagsRepository) {
        this.tagsRepository = tagsRepository;
    }

    @GET
    @Path(value="/")
    public List<Tag> getTag() {
        return this.tagsRepository.getTags();
    }

    @GET
    @Path(value="/{id:.+}")
    public Tag getTag(@PathParam(value="id") String id) {
        return this.tagsRepository.getTag(id);
    }

    @POST
    @Path(value="/")
    public Response createTag(BaseConfigurationItem bciTag) {
        LOG.debug("createTag(): ", (Object)bciTag);
        Tag tag = (Tag)bciTag;
        tag.setTagId(UUID.randomUUID().toString());
        tag.setId(Synthetic.TAG.jcrDirectory + "/" + tag.getTagId());
        this.tagsRepository.create(tag);
        Tag read = this.tagsRepository.getTag(tag.getId());
        return Response.status((int)201).entity((Object)read).build();
    }

    @PUT
    @Path(value="/{id:.+}")
    public Response updateTag(@PathParam(value="id") String id, BaseConfigurationItem bciTag) {
        Tag tag = (Tag)bciTag;
        Preconditions.checkArgument((boolean)id.equals(bciTag.getId()), (Object)String.format("Path variable id (%s) is not equal to the posted object id (%s).", id, bciTag.getId()));
        tag.validate();
        LOG.info("update item with id: " + tag.getId());
        if (id.equals(tag.getId())) {
            this.tagsRepository.update(tag);
            Tag read = this.tagsRepository.getTag(tag.getId());
            return Response.status((int)201).entity((Object)read).build();
        }
        return Response.status((int)409).build();
    }
}

