/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import ch.qos.logback.access.jetty.RequestLogImpl;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.xltest.ContextConfig;
import com.xebialabs.xltest.DataLoader;
import com.xebialabs.xltest.Environment;
import com.xebialabs.xltest.SessionCookieSetupListener;
import com.xebialabs.xltest.SpringContextHolder;
import com.xebialabs.xltest.XLTestErrorPageHandler;
import com.xebialabs.xltest.authentication.XltestLicenseCheckFilter;
import java.lang.management.ManagementFactory;
import java.security.Provider;
import java.security.Security;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class XLTest {
    private static final Logger LOG = LoggerFactory.getLogger(XLTest.class);
    private Server server;
    public static final String SESSION_COOKIE_NAME = "XLT_SESSION_ID";

    public void startWebApp() throws Exception {
        org.jboss.resteasy.logging.Logger.setLoggerType((Logger.LoggerType)Logger.LoggerType.SLF4J);
        this.startWebApp(this.webAppBindAddress(), this.webAppPortNumber(), ContextConfig.class);
    }

    public void startWebApp(String host, Integer port, Class<?> config) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(10);
        threadPool.setMaxThreads(1000);
        this.server = new Server((ThreadPool)threadPool);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(port.intValue());
        connector.setHost(host);
        this.server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)this.createWebAppContext(config));
        handlers.addHandler((Handler)new StatisticsHandler());
        this.server.setHandler((Handler)handlers);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addEventListener((Container.Listener)mbContainer);
        this.server.addBean((Object)mbContainer);
        try {
            this.server.start();
            this.server.setStopAtShutdown(true);
            DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
            DataLoader dataLoader = new DataLoader(SpringContextHolder.getRepositoryService(), SpringContextHolder.getElasticSearchClient(), SpringContextHolder.getEventRepository());
            if (dataLoader.loadBasicData() && SpringContextHolder.loadDemoData().booleanValue()) {
                dataLoader.loadDemoData("demodata/generate.py");
            }
        }
        catch (RuntimeException e) {
            this.server.stop();
            throw e;
        }
    }

    private String webAppBindAddress() {
        return System.getProperty("xlt.server.host", "0.0.0.0");
    }

    public String getContextPath() {
        return System.getProperty("xlt.server.root", "");
    }

    public int webAppPortNumber() {
        return Integer.getInteger("xlt.server.port", 6516);
    }

    public int getMaxSessionAge() {
        return Integer.getInteger("xlt.server.session.timeout", 30);
    }

    public void stopWebApp() throws Exception {
        this.server.stop();
        this.server.join();
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    private WebAppContext createWebAppContext(Class<?> config) {
        WebAppContext context = new WebAppContext();
        XLTestErrorPageHandler handler = new XLTestErrorPageHandler();
        handler.setShowStacks(false);
        if (Environment.isDevelopment()) {
            LOG.info("Running in development mode, showing stack traces in Jetty Error pages");
            handler.setShowStacks(true);
        }
        context.setErrorHandler((ErrorHandler)handler);
        boolean secureCookie = false;
        boolean httpOnly = true;
        int maxSessionAgeSeconds = this.getMaxSessionAge() * 60;
        context.setContextPath(this.getContextPath());
        context.setInitParameter("contextConfigLocation", config.getName());
        context.setInitParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        context.addEventListener((EventListener)((Object)new SessionCookieSetupListener(SESSION_COOKIE_NAME, secureCookie, httpOnly, maxSessionAgeSeconds)));
        context.addEventListener((EventListener)new ResteasyBootstrap());
        context.addEventListener((EventListener)new DeployitSpringContextLoaderListener());
        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        context.getInitParams().put("resteasy.servlet.mapping.prefix", "/");
        context.getInitParams().put("resteasy.document.expand.entity.references", "false");
        context.addServlet(servletHolder, "/*");
        context.setResourceBase(".");
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        context.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.addLicenseFilterToApi(context);
        context.setHandler(this.accessLogHandler());
        return context;
    }

    private Handler accessLogHandler() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        RequestLogImpl requestLogger = new RequestLogImpl();
        requestLogger.setQuiet(true);
        requestLogger.setResource("/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        return requestLogHandler;
    }

    private void addLicenseFilterToApi(WebAppContext context) {
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/dashboards", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/data", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/execute", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/hosts", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/import", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/projects", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/reports", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/test", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/testspecifications", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(XltestLicenseCheckFilter.class, "/api/internal/testtools", EnumSet.of(DispatcherType.REQUEST));
    }
}

