/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.google.common.base.Throwables;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.xltest.Spinner;
import com.xebialabs.xltest.SystemProperties;
import com.xebialabs.xltest.UpgradeContextConfig;
import com.xebialabs.xltest.XLTest;
import com.xebialabs.xltest.upgrade.XlTestViewUpgrader;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws Exception {
        if (SystemProperties.shouldUpgrade()) {
            Main.upgrade();
        } else {
            Main.bootstrapXlTest();
        }
    }

    public static void upgrade() {
        Spinner spinner = new Spinner("Upgrading XL TestView");
        spinner.start();
        try {
            LocalBooter.boot();
            Security.addProvider((Provider)new BouncyCastleProvider());
            AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext(new Class[]{UpgradeContextConfig.class});
            XlTestViewUpgrader upgrader = (XlTestViewUpgrader)((Object)ctx.getBean(XlTestViewUpgrader.class));
            upgrader.applyUpgrades();
            spinner.finish();
            Main.upgradeSuccessBanner();
            System.exit(0);
        }
        catch (Error | Exception e) {
            spinner.finishQuietly();
            Main.upgradeFailBanner(Throwables.getRootCause((Throwable)e).getMessage());
            System.exit(1);
        }
    }

    public static void bootstrapXlTest() {
        Spinner spinner = new Spinner("Starting XL TestView");
        spinner.start();
        try {
            LocalBooter.boot();
            XLTest xltest = new XLTest();
            xltest.startWebApp();
            spinner.finish();
            Main.successBanner(xltest);
            LOG.info("XL TestView up and running");
            xltest.join();
            System.exit(0);
        }
        catch (Error | Exception e) {
            spinner.finishQuietly();
            Main.failBanner(Throwables.getRootCause((Throwable)e).getMessage());
            System.exit(1);
        }
    }

    private static void successBanner(XLTest xltest) {
        System.out.println();
        System.out.println(String.format("Please open http://localhost:%d with a modern browser.", xltest.webAppPortNumber()));
        System.out.println();
    }

    private static void upgradeSuccessBanner() {
        System.out.println();
        System.out.println(String.format("XL TestView Upgrade succeeded", new Object[0]));
        System.out.println();
    }

    private static void failBanner(String message) {
        System.err.println();
        System.err.println(String.format("XL TestView Startup failed: %s%n%nThe server logs may contain more information.", message));
        System.err.println();
    }

    private static void upgradeFailBanner(String message) {
        System.err.println();
        System.err.println(String.format("XL TestView Upgrade failed: %s%n%nThe server logs may contain more information.", message));
        System.err.println();
    }
}

