/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class ImmortalCacheEntry
extends AbstractInternalCacheEntry {
    public Object value;

    public ImmortalCacheEntry(Object key, Object value) {
        super(key);
        this.value = value;
    }

    @Override
    public final boolean isExpired(long now) {
        return false;
    }

    @Override
    public final boolean isExpired() {
        return false;
    }

    @Override
    public final boolean canExpire() {
        return false;
    }

    @Override
    public final long getCreated() {
        return -1L;
    }

    @Override
    public final long getLastUsed() {
        return -1L;
    }

    @Override
    public final long getLifespan() {
        return -1L;
    }

    @Override
    public final long getMaxIdle() {
        return -1L;
    }

    @Override
    public final long getExpiryTime() {
        return -1L;
    }

    @Override
    public final void touch() {
    }

    @Override
    public void touch(long currentTimeMillis) {
    }

    @Override
    public final void reincarnate() {
    }

    @Override
    public void reincarnate(long now) {
    }

    @Override
    public InternalCacheValue toInternalCacheValue() {
        return new ImmortalCacheValue(this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object setValue(Object value) {
        this.value = value;
        return this.value;
    }

    @Override
    public Metadata getMetadata() {
        return new EmbeddedMetadata.Builder().build();
    }

    @Override
    public void setMetadata(Metadata metadata) {
        throw new IllegalStateException("Metadata cannot be set on immortal entries. They need to be recreated via the entry factory.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmortalCacheEntry that = (ImmortalCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public ImmortalCacheEntry clone() {
        return (ImmortalCacheEntry)super.clone();
    }

    @Override
    public String toString() {
        return "ImmortalCacheEntry{key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + "}";
    }

    public static class Externalizer
    extends AbstractExternalizer<ImmortalCacheEntry> {
        public void writeObject(ObjectOutput output, ImmortalCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(ice.value);
        }

        public ImmortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            return new ImmortalCacheEntry(k, v);
        }

        public Integer getId() {
            return 10;
        }

        public Set<Class<? extends ImmortalCacheEntry>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{ImmortalCacheEntry.class});
        }
    }
}

