/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

public class ExecutionResult {
    private final ExecutionStatus executionStatus;
    private final long timeElapsed;
    private final String message;

    public ExecutionResult(ExecutionStatus executionStatus, long timeElapsed) {
        this(executionStatus, timeElapsed, "");
    }

    public ExecutionResult(ExecutionStatus executionStatus, long timeElapsed, String message) {
        this.executionStatus = executionStatus;
        this.timeElapsed = timeElapsed;
        this.message = message;
    }

    public static ExecutionResult running(long timeElapsed) {
        return new ExecutionResult(ExecutionStatus.RUNNING, timeElapsed);
    }

    public static ExecutionResult finished() {
        return new ExecutionResult(ExecutionStatus.FINISHED, 0L);
    }

    public static ExecutionResult failed() {
        return new ExecutionResult(ExecutionStatus.FAILED, 0L);
    }

    public static ExecutionResult failed(String msg) {
        return new ExecutionResult(ExecutionStatus.FAILED, 0L, msg);
    }

    public static ExecutionResult malformedInput(String msg) {
        return new ExecutionResult(ExecutionStatus.MALFORMED_INPUT, 0L, msg);
    }

    public static ExecutionResult noData(String message) {
        return new ExecutionResult(ExecutionStatus.NO_DATA, 0L, message);
    }

    public static ExecutionResult unknownError(String message) {
        return new ExecutionResult(ExecutionStatus.UNKNOWN_ERROR, 0L, message);
    }

    public static ExecutionResult notRunning() {
        return new ExecutionResult(ExecutionStatus.NOT_RUNNING, -1L);
    }

    public static ExecutionResult cannotRewriteHistory(String message) {
        return new ExecutionResult(ExecutionStatus.CANNOT_REWRITE_HISTORY, -1L, message);
    }

    public long getTimeElapsed() {
        return this.timeElapsed;
    }

    public boolean isRunning() {
        return this.executionStatus == ExecutionStatus.RUNNING;
    }

    public ExecutionStatus getStatus() {
        return this.executionStatus;
    }

    public boolean isDoneRunning() {
        return this.executionStatus == ExecutionStatus.FINISHED || this.executionStatus == ExecutionStatus.FAILED;
    }

    public String getMessage() {
        return this.message;
    }

    public static enum ExecutionStatus {
        NOT_RUNNING("not running"),
        RUNNING("running"),
        FINISHED("finished"),
        FAILED("failed"),
        MALFORMED_INPUT("malformed input"),
        CANNOT_REWRITE_HISTORY("cannot rewrite history"),
        NO_DATA("no data"),
        UNKNOWN_ERROR("unknown error");

        private String status;

        private ExecutionStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

