/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;

public class Link
extends SymbolType
implements Rule,
Translation {
    public static final Link symbolType = new Link();
    public static final String ImageProperty = "image";
    public static final String WidthProperty = "width";
    public static final String StyleProperty = "style";
    public static final String Left = "left";
    public static final String Right = "right";

    public Link() {
        super("Link");
        this.wikiMatcher(new Matcher().string("http://"));
        this.wikiMatcher(new Matcher().string("https://"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol targetList = parser.parseToEnds(-1, SymbolProvider.linkTargetProvider, new SymbolType[]{SymbolType.Newline, SymbolType.Whitespace});
        return new Maybe<Symbol>(current.add(targetList));
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        String target = symbol.getContent() + translator.translate(symbol.childAt(0));
        return this.buildLink(translator, target, symbol);
    }

    public String buildLink(Translator translator, String body, Symbol link) {
        HtmlTag tag;
        Reference reference = new Reference(translator.translate(link.childAt(0)));
        String prefix = link.getContent();
        if (link.hasProperty(ImageProperty) || reference.isImage()) {
            String style;
            String width;
            tag = new HtmlTag("img");
            tag.addAttribute("src", reference.makeUrl(prefix));
            String imageClass = link.getProperty(ImageProperty);
            if (!imageClass.isEmpty()) {
                tag.addAttribute("class", imageClass);
            }
            if (!(width = link.getProperty(WidthProperty)).isEmpty()) {
                tag.addAttribute(WidthProperty, width);
            }
            if (!(style = link.getProperty(StyleProperty)).isEmpty()) {
                tag.addAttribute(StyleProperty, style);
            }
        } else {
            tag = new HtmlTag("a", body);
            tag.addAttribute("href", reference.makeUrl(prefix));
        }
        return tag.htmlInline();
    }

    private class Reference {
        private String reference;

        public Reference(String reference) {
            this.reference = reference;
        }

        public boolean isImage() {
            return this.reference.toLowerCase().endsWith(".jpg") || this.reference.toLowerCase().endsWith(".gif") || this.reference.toLowerCase().endsWith(".png");
        }

        public String makeUrl(String prefix) {
            return this.reference.startsWith("files/") ? this.reference : prefix + this.reference;
        }
    }
}

