/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.InputStreamResponse;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.files.DirectoryResponder;
import fitnesse.util.Clock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.Date;
import util.StreamReader;

public class FileResponder
implements SecureResponder {
    private static final Date LAST_MODIFIED_FOR_RESOURCES = new Date(System.currentTimeMillis() / 1000L * 1000L);
    private static final int RESOURCE_SIZE_LIMIT = 262144;
    private static final FileNameMap fileNameMap = URLConnection.getFileNameMap();
    String resource;
    File requestedFile;
    Date lastModifiedDate;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws IOException {
        String rootPath = context.getRootPagePath();
        try {
            this.resource = URLDecoder.decode(request.getResource(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new ErrorResponder(e).makeResponse(context, request);
        }
        this.requestedFile = new File(rootPath, this.resource);
        if (!FileResponder.isInFilesDirectory(new File(rootPath), this.requestedFile)) {
            return new ErrorResponder("Invalid path: " + this.resource).makeResponse(context, request);
        }
        if (this.requestedFile.isDirectory()) {
            return new DirectoryResponder(this.resource, this.requestedFile).makeResponse(context, request);
        }
        if (this.requestedFile.exists()) {
            return this.makeFileResponse(request);
        }
        if (this.canLoadFromClasspath()) {
            return this.makeClasspathResponse(context, request);
        }
        return new NotFoundResponder().makeResponse(context, request);
    }

    private boolean canLoadFromClasspath() {
        return this.resource.startsWith("files/fitnesse/");
    }

    private Response makeClasspathResponse(FitNesseContext context, Request request) throws IOException {
        this.determineLastModifiedInfo(LAST_MODIFIED_FOR_RESOURCES);
        if (this.isNotModified(request)) {
            return this.createNotModifiedResponse();
        }
        String classpathResource = "/fitnesse/resources/" + this.resource.substring("files/fitnesse/".length());
        InputStream input = this.getClass().getResourceAsStream(classpathResource);
        if (input == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        StreamReader reader = new StreamReader(input);
        byte[] content = reader.readBytes(262144);
        SimpleResponse response = new SimpleResponse();
        response.setContent(content);
        this.setContentType(classpathResource, response);
        this.lastModifiedDate = LAST_MODIFIED_FOR_RESOURCES;
        response.setLastModifiedHeader(this.lastModifiedDate);
        return response;
    }

    private Response makeFileResponse(Request request) throws FileNotFoundException {
        InputStreamResponse response = new InputStreamResponse();
        this.determineLastModifiedInfo(new Date(this.requestedFile.lastModified()));
        if (this.isNotModified(request)) {
            return this.createNotModifiedResponse();
        }
        response.setBody(this.requestedFile);
        this.setContentType(this.requestedFile.getName(), response);
        response.setLastModifiedHeader(this.lastModifiedDate);
        return response;
    }

    private boolean isNotModified(Request request) {
        if (request.hasHeader("If-Modified-Since")) {
            String queryDateString = request.getHeader("If-Modified-Since");
            try {
                Date queryDate = Response.makeStandardHttpDateFormat().parse(queryDateString);
                if (!queryDate.before(this.lastModifiedDate)) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    private Response createNotModifiedResponse() {
        SimpleResponse response = new SimpleResponse();
        response.notModified(this.lastModifiedDate, Clock.currentDate());
        return response;
    }

    private void determineLastModifiedInfo(Date lastModified) {
        this.lastModifiedDate = new Date(lastModified.getTime() / 1000L * 1000L);
    }

    private void setContentType(String filename, Response response) {
        String contentType = FileResponder.getContentType(filename);
        response.setContentType(contentType);
    }

    public static String getContentType(String filename) {
        String contentType = fileNameMap.getContentTypeFor(filename);
        if (contentType == null) {
            contentType = filename.endsWith(".css") ? "text/css" : (filename.endsWith(".js") ? "text/javascript" : (filename.endsWith(".jar") ? "application/x-java-archive" : (filename.endsWith(".jpg") || filename.endsWith(".jpeg") ? "image/jpeg" : (filename.endsWith(".png") ? "image/png" : (filename.endsWith(".gif") ? "image/gif" : (filename.endsWith(".svg") ? "image/svg+xml" : "text/plain"))))));
        }
        return contentType;
    }

    public static boolean isInFilesDirectory(File rootPath, File file) throws IOException {
        return FileResponder.isInSubDirectory(new File(rootPath, "files").getCanonicalFile(), file.getCanonicalFile());
    }

    private static boolean isInSubDirectory(File dir, File file) {
        return file != null && (file.equals(dir) || FileResponder.isInSubDirectory(dir, file.getParentFile()));
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureOperation(){

            @Override
            public boolean shouldAuthenticate(FitNesseContext context, Request request) {
                try {
                    return new File(context.getRootPagePath(), URLDecoder.decode(request.getResource(), "UTF-8")).isDirectory();
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Invalid URL encoding", e);
                }
            }
        };
    }
}

