/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.infinispan.schematic.document.NotThreadSafe;

@NotThreadSafe
public class BufferCache {
    public static final int MINIMUM_SIZE = 8384;
    public static final int MAXIMUM_SIZE = 83840;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(8384);
    private CharBuffer charBuffer = CharBuffer.allocate(8384);

    public ByteBuffer getByteBuffer(int minimumSize) {
        minimumSize = Math.max(minimumSize, 8384);
        ByteBuffer buffer = this.byteBuffer;
        if (buffer == null || buffer.capacity() < minimumSize) {
            buffer = ByteBuffer.allocate(minimumSize);
        } else {
            this.byteBuffer = null;
            buffer.clear();
        }
        return buffer;
    }

    public CharBuffer getCharBuffer(int minimumSize) {
        minimumSize = Math.max(minimumSize, 8384);
        CharBuffer buffer = this.charBuffer;
        if (buffer == null || buffer.capacity() < minimumSize) {
            buffer = CharBuffer.allocate(minimumSize);
        } else {
            this.charBuffer = null;
            buffer.clear();
        }
        return buffer;
    }

    public void checkin(ByteBuffer byteBuffer) {
        if (byteBuffer.capacity() < 83840) {
            this.byteBuffer = byteBuffer;
        }
    }

    public void checkin(CharBuffer charBuffer) {
        if (this.byteBuffer.capacity() < 83840) {
            this.charBuffer = charBuffer;
        }
    }
}

