/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.lucene.search.NoCacheFilter;
import org.elasticsearch.common.lucene.search.NoCacheQuery;
import org.elasticsearch.common.lucene.search.ResolvableFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NumericDateAnalyzer;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.search.internal.SearchContext;

public class DateFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "date";
    protected FormatDateTimeFormatter dateTimeFormatter;
    private final boolean roundCeil;
    private final DateMathParser dateMathParser;
    private String nullValue;
    protected final TimeUnit timeUnit;

    protected DateFieldMapper(FieldMapper.Names names, FormatDateTimeFormatter dateTimeFormatter, int precisionStep, float boost, FieldType fieldType, Boolean docValues, String nullValue, TimeUnit timeUnit, boolean roundCeil, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings, AbstractFieldMapper.MultiFields multiFields, AbstractFieldMapper.CopyTo copyTo) {
        super(names, precisionStep, boost, fieldType, docValues, ignoreMalformed, coerce, NumericDateAnalyzer.buildNamedAnalyzer(dateTimeFormatter, precisionStep), NumericDateAnalyzer.buildNamedAnalyzer(dateTimeFormatter, Integer.MAX_VALUE), postingsProvider, docValuesProvider, similarity, normsLoading, fieldDataSettings, indexSettings, multiFields, copyTo);
        this.dateTimeFormatter = dateTimeFormatter;
        this.nullValue = nullValue;
        this.timeUnit = timeUnit;
        this.roundCeil = roundCeil;
        this.dateMathParser = new DateMathParser(dateTimeFormatter, timeUnit);
    }

    public FormatDateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public DateMathParser dateMathParser() {
        return this.dateMathParser;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("long");
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return Numbers.bytesToLong((BytesRef)value);
        }
        return this.parseStringValue(value.toString());
    }

    @Override
    public Object valueForSearch(Object value) {
        if (value instanceof String) {
            return value;
        }
        Long val = this.value(value);
        if (val == null) {
            return null;
        }
        return this.dateTimeFormatter.printer().print(val);
    }

    @Override
    public BytesRef indexedValueForSearch(Object value) {
        BytesRefBuilder bytesRef = new BytesRefBuilder();
        NumericUtils.longToPrefixCoded((long)this.parseValue(value), (int)0, (BytesRefBuilder)bytesRef);
        return bytesRef.get();
    }

    private long parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return this.dateTimeFormatter.parser().parseMillis(((BytesRef)value).utf8ToString());
        }
        return this.dateTimeFormatter.parser().parseMillis(value.toString());
    }

    private String convertToString(Object value) {
        if (value instanceof BytesRef) {
            return ((BytesRef)value).utf8ToString();
        }
        return value.toString();
    }

    private static Callable<Long> now() {
        return new Callable<Long>(){

            @Override
            public Long call() {
                SearchContext context = SearchContext.current();
                return context != null ? context.nowInMillis() : System.currentTimeMillis();
            }
        };
    }

    @Override
    public Query fuzzyQuery(String value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        long iSim;
        long iValue = this.dateMathParser.parse(value, DateFieldMapper.now());
        try {
            iSim = fuzziness.asTimeValue().millis();
        }
        catch (Exception e) {
            iSim = fuzziness.asLong();
        }
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(iValue - iSim), (Long)(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query termQuery(Object value, @Nullable QueryParseContext context) {
        long lValue = this.parseToMilliseconds(value);
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)lValue, (Long)lValue, (boolean)true, (boolean)true);
    }

    public long parseToMilliseconds(Object value) {
        return this.parseToMilliseconds(value, false, null, this.dateMathParser);
    }

    public long parseToMilliseconds(Object value, boolean inclusive, @Nullable DateTimeZone zone, @Nullable DateMathParser forcedDateParser) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return this.parseToMilliseconds(this.convertToString(value), inclusive, zone, forcedDateParser);
    }

    public long parseToMilliseconds(String value, boolean inclusive, @Nullable DateTimeZone zone, @Nullable DateMathParser forcedDateParser) {
        DateMathParser dateParser = this.dateMathParser;
        if (forcedDateParser != null) {
            dateParser = forcedDateParser;
        }
        boolean roundUp = inclusive && this.roundCeil;
        return dateParser.parse(value, DateFieldMapper.now(), roundUp, zone);
    }

    @Override
    public Filter termFilter(Object value, @Nullable QueryParseContext context) {
        long lValue = this.parseToMilliseconds(value);
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)lValue, (Long)lValue, (boolean)true, (boolean)true);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return this.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, null, null, context);
    }

    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser, @Nullable QueryParseContext context) {
        if (SearchContext.current() == null) {
            return new LateParsingQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, forcedDateParser);
        }
        return this.innerRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, timeZone, forcedDateParser);
    }

    private Query innerRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser) {
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, lowerTerm == null ? null : Long.valueOf(this.parseToMilliseconds(lowerTerm, !includeLower, timeZone, forcedDateParser == null ? this.dateMathParser : forcedDateParser)), upperTerm == null ? null : Long.valueOf(this.parseToMilliseconds(upperTerm, includeUpper, timeZone, forcedDateParser == null ? this.dateMathParser : forcedDateParser)), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return this.rangeFilter(lowerTerm, upperTerm, includeLower, includeUpper, null, null, context, null);
    }

    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser, @Nullable QueryParseContext context, @Nullable Boolean explicitCaching) {
        return this.rangeFilter(null, lowerTerm, upperTerm, includeLower, includeUpper, timeZone, forcedDateParser, context, explicitCaching);
    }

    @Override
    public Filter rangeFilter(QueryParseContext parseContext, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return this.rangeFilter(parseContext, lowerTerm, upperTerm, includeLower, includeUpper, null, null, context, null);
    }

    public Filter rangeFilter(QueryParseContext parseContext, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser, @Nullable QueryParseContext context, @Nullable Boolean explicitCaching) {
        IndexNumericFieldData fieldData;
        IndexNumericFieldData indexNumericFieldData = fieldData = parseContext != null ? (IndexNumericFieldData)parseContext.getForField(this) : null;
        if (SearchContext.current() == null) {
            return new LateParsingFilter(fieldData, lowerTerm, upperTerm, includeLower, includeUpper, timeZone, forcedDateParser, explicitCaching);
        }
        return this.innerRangeFilter(fieldData, lowerTerm, upperTerm, includeLower, includeUpper, timeZone, forcedDateParser, explicitCaching);
    }

    private Filter innerRangeFilter(IndexNumericFieldData fieldData, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable DateTimeZone timeZone, @Nullable DateMathParser forcedDateParser, @Nullable Boolean explicitCaching) {
        String value;
        boolean cacheable = true;
        Long lowerVal = null;
        Long upperVal = null;
        if (lowerTerm != null) {
            if (lowerTerm instanceof Number) {
                lowerVal = ((Number)lowerTerm).longValue();
            } else {
                value = this.convertToString(lowerTerm);
                cacheable = !this.hasDateExpressionWithNoRounding(value);
                lowerVal = this.parseToMilliseconds(value, false, timeZone, forcedDateParser);
            }
        }
        if (upperTerm != null) {
            if (upperTerm instanceof Number) {
                upperVal = ((Number)upperTerm).longValue();
            } else {
                value = this.convertToString(upperTerm);
                cacheable = cacheable && !this.hasDateExpressionWithNoRounding(value);
                upperVal = this.parseToMilliseconds(value, includeUpper, timeZone, forcedDateParser);
            }
        }
        boolean cache = explicitCaching != null ? (explicitCaching.booleanValue() ? cacheable : false) : cacheable;
        NumericRangeFilter filter = fieldData != null ? NumericRangeFieldDataFilter.newLongRange(fieldData, lowerVal, upperVal, includeLower, includeUpper) : NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)lowerVal, (Long)upperVal, (boolean)includeLower, (boolean)includeUpper);
        if (!cache) {
            return NoCacheFilter.wrap((Filter)filter);
        }
        return filter;
    }

    private boolean hasDateExpressionWithNoRounding(String value) {
        int index = value.indexOf("now");
        if (index != -1) {
            if (value.length() == 3) {
                return true;
            }
            int indexOfPotentialRounding = index + 3;
            if (indexOfPotentialRounding >= value.length()) {
                return true;
            }
            do {
                char potentialRoundingChar;
                if ((potentialRoundingChar = value.charAt(indexOfPotentialRounding++)) == '/') {
                    return false;
                }
                if (potentialRoundingChar != ' ') continue;
                return true;
            } while (indexOfPotentialRounding < value.length());
            return true;
        }
        return false;
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        long value = this.parseStringValue(this.nullValue);
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)value, (Long)value, (boolean)true, (boolean)true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        String dateAsString = null;
        Long value = null;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue instanceof Number) {
                value = ((Number)externalValue).longValue();
            } else {
                dateAsString = (String)externalValue;
                if (dateAsString == null) {
                    dateAsString = this.nullValue;
                }
            }
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                dateAsString = this.nullValue;
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                value = parser.longValue((Boolean)this.coerce.value());
            } else if (token == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (token == XContentParser.Token.VALUE_NULL) {
                            dateAsString = this.nullValue;
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            value = parser.longValue((Boolean)this.coerce.value());
                            continue;
                        }
                        dateAsString = parser.text();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticsearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
            } else {
                dateAsString = parser.text();
            }
        }
        if (dateAsString != null) {
            assert (value == null);
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.names.fullName(), dateAsString, boost);
            }
            value = this.parseStringValue(dateAsString);
        }
        if (value != null) {
            if (this.fieldType.indexed() || this.fieldType.stored()) {
                LongFieldMapper.CustomLongNumericField field = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, value, this.fieldType);
                field.setBoost(boost);
                fields.add(field);
            }
            if (this.hasDocValues()) {
                this.addDocValue(context, fields, value);
            }
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((DateFieldMapper)mergeWith).nullValue;
            this.dateTimeFormatter = ((DateFieldMapper)mergeWith).dateTimeFormatter;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.precisionStep != 16) {
            builder.field("precision_step", this.precisionStep);
        }
        builder.field("format", this.dateTimeFormatter.format());
        if (includeDefaults || this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
        if (includeDefaults || this.timeUnit != Defaults.TIME_UNIT) {
            builder.field("numeric_resolution", this.timeUnit.name().toLowerCase(Locale.ROOT));
        }
        if (this.dateTimeFormatter.locale() != null && this.dateTimeFormatter.locale() != Locale.ROOT) {
            builder.field("locale", (Object)this.dateTimeFormatter.locale());
        } else if (includeDefaults) {
            if (this.dateTimeFormatter.locale() == null) {
                builder.field("locale", (Object)Locale.ROOT);
            } else {
                builder.field("locale", (Object)this.dateTimeFormatter.locale());
            }
        }
    }

    private long parseStringValue(String value) {
        try {
            return this.dateTimeFormatter.parser().parseMillis(value);
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new MapperParsingException("failed to parse date field [" + value + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number with locale [" + this.dateTimeFormatter.locale() + "]", e);
            }
        }
    }

    public final class LateParsingQuery
    extends NoCacheQuery {
        final Object lowerTerm;
        final Object upperTerm;
        final boolean includeLower;
        final boolean includeUpper;
        final DateTimeZone timeZone;
        final DateMathParser forcedDateParser;

        public LateParsingQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, DateTimeZone timeZone, DateMathParser forcedDateParser) {
            this.lowerTerm = lowerTerm;
            this.upperTerm = upperTerm;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
            this.timeZone = timeZone;
            this.forcedDateParser = forcedDateParser;
        }

        public Query rewrite(IndexReader reader) throws IOException {
            Query query = DateFieldMapper.this.innerRangeQuery(this.lowerTerm, this.upperTerm, this.includeLower, this.includeUpper, this.timeZone, this.forcedDateParser);
            return query.rewrite(reader);
        }

        @Override
        public String innerToString(String s) {
            StringBuilder sb = new StringBuilder();
            return sb.append(DateFieldMapper.this.names.indexName()).append(':').append(this.includeLower ? (char)'[' : '{').append(this.lowerTerm == null ? "*" : this.lowerTerm.toString()).append(" TO ").append(this.upperTerm == null ? "*" : this.upperTerm.toString()).append(this.includeUpper ? (char)']' : '}').append(ToStringUtils.boost((float)this.getBoost())).toString();
        }
    }

    private final class LateParsingFilter
    extends ResolvableFilter {
        final IndexNumericFieldData fieldData;
        final Object lowerTerm;
        final Object upperTerm;
        final boolean includeLower;
        final boolean includeUpper;
        final DateTimeZone timeZone;
        final DateMathParser forcedDateParser;
        final Boolean explicitCaching;

        public LateParsingFilter(IndexNumericFieldData fieldData, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, DateTimeZone timeZone, DateMathParser forcedDateParser, Boolean explicitCaching) {
            this.fieldData = fieldData;
            this.lowerTerm = lowerTerm;
            this.upperTerm = upperTerm;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
            this.timeZone = timeZone;
            this.forcedDateParser = forcedDateParser;
            this.explicitCaching = explicitCaching;
        }

        @Override
        public Filter resolve() {
            return DateFieldMapper.this.innerRangeFilter(this.fieldData, this.lowerTerm, this.upperTerm, this.includeLower, this.includeUpper, this.timeZone, this.forcedDateParser, this.explicitCaching);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.dateField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propNode));
                    continue;
                }
                if (propName.equals("numeric_resolution")) {
                    builder.timeUnit(TimeUnit.valueOf(propNode.toString().toUpperCase(Locale.ROOT)));
                    continue;
                }
                if (!propName.equals("locale")) continue;
                builder.locale(LocaleUtils.parse(propNode.toString()));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, DateFieldMapper> {
        protected TimeUnit timeUnit = Defaults.TIME_UNIT;
        protected String nullValue = Defaults.NULL_VALUE;
        protected FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;
        private Locale locale;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE), 16);
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            boolean roundCeil = true;
            if (context.indexSettings() != null) {
                Settings settings = context.indexSettings();
                roundCeil = settings.getAsBoolean("index.mapping.date.round_ceil", settings.getAsBoolean("index.mapping.date.parse_upper_inclusive", (Boolean)true));
            }
            this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.boost == 1.0f);
            if (!this.locale.equals(this.dateTimeFormatter.locale())) {
                this.dateTimeFormatter = new FormatDateTimeFormatter(this.dateTimeFormatter.format(), this.dateTimeFormatter.parser(), this.dateTimeFormatter.printer(), this.locale);
            }
            DateFieldMapper fieldMapper = new DateFieldMapper(this.buildNames(context), this.dateTimeFormatter, this.fieldType.numericPrecisionStep(), this.boost, this.fieldType, this.docValues, this.nullValue, this.timeUnit, roundCeil, this.ignoreMalformed(context), this.coerce(context), this.postingsProvider, this.docValuesProvider, this.similarity, this.normsLoading, this.fieldDataSettings, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime", Locale.ROOT);
        public static final FieldType FIELD_TYPE = new FieldType(NumberFieldMapper.Defaults.FIELD_TYPE);
        public static final String NULL_VALUE;
        public static final TimeUnit TIME_UNIT;
        public static final boolean ROUND_CEIL = true;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
            TIME_UNIT = TimeUnit.MILLISECONDS;
        }
    }
}

