/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.docvaluesformat;

import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormats;
import org.elasticsearch.index.codec.docvaluesformat.PreBuiltDocValuesFormatProvider;
import org.elasticsearch.index.settings.IndexSettings;

public class DocValuesFormatService
extends AbstractIndexComponent {
    private final ImmutableMap<String, DocValuesFormatProvider> providers;
    public static final String DEFAULT_FORMAT = "default";

    public DocValuesFormatService(Index index) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public DocValuesFormatService(Index index, @IndexSettings Settings indexSettings) {
        this(index, indexSettings, ImmutableMap.of());
    }

    @Inject
    public DocValuesFormatService(Index index, @IndexSettings Settings indexSettings, Map<String, DocValuesFormatProvider.Factory> docValuesFormatFactories) {
        super(index, indexSettings);
        MapBuilder<String, DocValuesFormatProvider> providers = MapBuilder.newMapBuilder();
        Map<String, Settings> docValuesFormatSettings = indexSettings.getGroups("index.codec.doc_values_format");
        for (Map.Entry<String, DocValuesFormatProvider.Factory> entry : docValuesFormatFactories.entrySet()) {
            String name = entry.getKey();
            DocValuesFormatProvider.Factory factory = entry.getValue();
            Settings settings = docValuesFormatSettings.get(name);
            if (settings == null) {
                settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
            }
            providers.put(name, factory.create(name, settings));
        }
        for (PreBuiltDocValuesFormatProvider.Factory factory : DocValuesFormats.listFactories()) {
            if (providers.containsKey(factory.name())) continue;
            providers.put(factory.name(), factory.get());
        }
        this.providers = providers.immutableMap();
    }

    public DocValuesFormatProvider get(String name) throws ElasticsearchIllegalArgumentException {
        DocValuesFormatProvider provider = this.providers.get(name);
        if (provider == null) {
            throw new ElasticsearchIllegalArgumentException("failed to find doc_values_format [" + name + "]");
        }
        return provider;
    }
}

