/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class TransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends AbstractComponent {
    protected final ThreadPool threadPool;
    protected final String actionName;
    private final ActionFilter[] filters;

    protected TransportAction(Settings settings, String actionName, ThreadPool threadPool, ActionFilters actionFilters) {
        super(settings);
        this.actionName = actionName;
        this.filters = actionFilters.filters();
        this.threadPool = threadPool;
    }

    public final ActionFuture<Response> execute(Request request) throws ElasticsearchException {
        PlainActionFuture future = PlainActionFuture.newFuture();
        ((ActionRequest)request).listenerThreaded(false);
        this.execute(request, future);
        return future;
    }

    public final void execute(Request request, ActionListener<Response> listener) {
        ActionRequestValidationException validationException;
        if (this.forceThreadedListener()) {
            ((ActionRequest)request).listenerThreaded(true);
        }
        if (((ActionRequest)request).listenerThreaded()) {
            listener = new ThreadedActionListener<Response>(this.threadPool, listener, this.logger);
        }
        if ((validationException = ((ActionRequest)request).validate()) != null) {
            listener.onFailure(validationException);
            return;
        }
        if (this.filters.length == 0) {
            try {
                this.doExecute(request, listener);
            }
            catch (Throwable t) {
                this.logger.trace("Error during transport action execution.", t, new Object[0]);
                listener.onFailure(t);
            }
        } else {
            RequestFilterChain requestFilterChain = new RequestFilterChain(this, this.logger);
            requestFilterChain.proceed(this.actionName, (ActionRequest)request, (ActionListener)listener);
        }
    }

    protected boolean forceThreadedListener() {
        return false;
    }

    protected abstract void doExecute(Request var1, ActionListener<Response> var2);

    private static class FilteredActionListener<Response extends ActionResponse>
    implements ActionListener<Response> {
        private final String actionName;
        private final ActionListener listener;
        private final ResponseFilterChain chain;

        private FilteredActionListener(String actionName, ActionListener listener, ResponseFilterChain chain) {
            this.actionName = actionName;
            this.listener = listener;
            this.chain = chain;
        }

        @Override
        public void onResponse(Response response) {
            this.chain.proceed(this.actionName, (ActionResponse)response, this.listener);
        }

        @Override
        public void onFailure(Throwable e) {
            this.listener.onFailure(e);
        }
    }

    private static class ResponseFilterChain
    implements ActionFilterChain {
        private final ActionFilter[] filters;
        private final AtomicInteger index;
        private final ESLogger logger;

        private ResponseFilterChain(ActionFilter[] filters, ESLogger logger) {
            this.filters = filters;
            this.index = new AtomicInteger(filters.length);
            this.logger = logger;
        }

        @Override
        public void proceed(String action, ActionRequest request, ActionListener listener) {
            assert (false) : "response filter chain should never be called on the request side";
        }

        @Override
        public void proceed(String action, ActionResponse response, ActionListener listener) {
            int i = this.index.decrementAndGet();
            try {
                if (i >= 0) {
                    this.filters[i].apply(action, response, listener, (ActionFilterChain)this);
                } else if (i == -1) {
                    listener.onResponse(response);
                } else {
                    listener.onFailure(new IllegalStateException("proceed was called too many times"));
                }
            }
            catch (Throwable t) {
                this.logger.trace("Error during transport action execution.", t, new Object[0]);
                listener.onFailure(t);
            }
        }
    }

    private static class RequestFilterChain<Request extends ActionRequest, Response extends ActionResponse>
    implements ActionFilterChain {
        private final TransportAction<Request, Response> action;
        private final AtomicInteger index = new AtomicInteger();
        private final ESLogger logger;

        private RequestFilterChain(TransportAction<Request, Response> action, ESLogger logger) {
            this.action = action;
            this.logger = logger;
        }

        @Override
        public void proceed(String actionName, ActionRequest request, ActionListener listener) {
            int i = this.index.getAndIncrement();
            try {
                if (i < ((TransportAction)this.action).filters.length) {
                    ((TransportAction)this.action).filters[i].apply(actionName, request, listener, (ActionFilterChain)this);
                } else if (i == ((TransportAction)this.action).filters.length) {
                    this.action.doExecute(request, new FilteredActionListener(actionName, listener, new ResponseFilterChain(((TransportAction)this.action).filters, this.logger)));
                } else {
                    listener.onFailure(new IllegalStateException("proceed was called too many times"));
                }
            }
            catch (Throwable t) {
                this.logger.trace("Error during transport action execution.", t, new Object[0]);
                listener.onFailure(t);
            }
        }

        @Override
        public void proceed(String action, ActionResponse response, ActionListener listener) {
            assert (false) : "request filter chain should never be called on the response side";
        }
    }

    static final class ThreadedActionListener<Response>
    implements ActionListener<Response> {
        private final ThreadPool threadPool;
        private final ActionListener<Response> listener;
        private final ESLogger logger;

        ThreadedActionListener(ThreadPool threadPool, ActionListener<Response> listener, ESLogger logger) {
            this.threadPool = threadPool;
            this.listener = listener;
            this.logger = logger;
        }

        @Override
        public void onResponse(final Response response) {
            try {
                this.threadPool.executor("listener").execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ThreadedActionListener.this.listener.onResponse(response);
                        }
                        catch (Throwable e) {
                            ThreadedActionListener.this.listener.onFailure(e);
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException ex) {
                this.logger.debug("Can not run threaded action, execution rejected [{}] running on current thread", this.listener);
                try {
                    this.listener.onResponse(response);
                }
                catch (Throwable e) {
                    this.listener.onFailure(e);
                }
            }
        }

        @Override
        public void onFailure(final Throwable e) {
            try {
                this.threadPool.executor("listener").execute(new Runnable(){

                    @Override
                    public void run() {
                        ThreadedActionListener.this.listener.onFailure(e);
                    }
                });
            }
            catch (EsRejectedExecutionException ex) {
                this.logger.debug("Can not run threaded action, execution rejected for listener [{}] running on current thread", this.listener);
                this.listener.onFailure(e);
            }
        }
    }
}

