/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.io.TemporaryFiles;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.repository.NodeReaderContext;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class ClosingExceptionMapper<E extends Exception>
implements ExceptionMapper<E> {
    public static final String X_EXCEPTION_TYPE = "X-Exception-Type";
    public static final String X_PATH = "X-Path";
    protected final boolean hideInternals;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected ClosingExceptionMapper(boolean hideInternals) {
        this.hideInternals = hideInternals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Response toResponse(E exception) {
        try {
            Response response = this.handleException(exception);
            return response;
        }
        finally {
            if (JcrTemplateHolder.get().isLoggedIn()) {
                JcrTemplateHolder.get().logout();
                NodeReaderContext.get().release();
            }
            TemporaryFiles.clear();
            WorkdirHolder.clear();
            PathInterceptor.PATH.remove();
            MDC.remove((String)"username");
        }
    }

    protected abstract Response handleException(E var1);

    protected Response checkWhetherWeHideInternals(int status, RuntimeException e, String content) {
        if (status > 499 && this.hideInternals) {
            UUID uuid = UUID.randomUUID();
            this.logger.error("[UUID={}] Encountered statuscode [{}], hiding it with a 400.", (Object)uuid, (Object)status);
            this.logger.error("[UUID={}] Exception: {}", (Object)uuid, (Object)e.getClass().getName());
            this.logger.error("[UUID={}] Error messages: {}", (Object)uuid, (Object)content);
            return Response.status((int)400).type("text/plain").entity((Object)("An internal error has occurred, please notify your system administrator with the following code: " + uuid)).build();
        }
        return null;
    }
}

