/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.util.List;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.permissions.ConditionalPermission;
import org.knopflerfish.framework.permissions.ConditionalPermissionSecurityManager;
import org.knopflerfish.framework.permissions.PostponementCheck;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KFSecurityManager
extends SecurityManager
implements ConditionalPermissionSecurityManager {
    private final ThreadLocal<PostponementCheck<?>> postponementCheck = new ThreadLocal();
    private final Debug debug;

    public KFSecurityManager(FrameworkContext fwCtx) {
        this.debug = fwCtx.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPermission(Permission perm, Object context) {
        if (!(context instanceof AccessControlContext)) {
            throw new SecurityException("Context not an AccessControlContext");
        }
        PostponementCheck<?> old = this.postponementCheck.get();
        PostponementCheck pc = new PostponementCheck((AccessControlContext)context, perm, old);
        this.postponementCheck.set(pc);
        try {
            AccessController.doPrivileged(pc);
        }
        finally {
            this.postponementCheck.set(old);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        this.checkPermission(perm, this.getSecurityContext());
    }

    @Override
    public boolean isPostponeAvailable() {
        return this.postponementCheck.get() != null;
    }

    @Override
    public void savePostponement(List<ConditionalPermission> postponement, Object debug) {
        PostponementCheck<?> pc = this.postponementCheck.get();
        pc.savePostponement(postponement, debug);
    }
}

