/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Queue;
import org.knopflerfish.framework.Resolver;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartLevelController
implements Runnable,
ServiceFactory<StartLevel> {
    public static final String SPEC_VERSION = "1.1";
    public static final String API_SPEC_VERSION = "1.0";
    static final int START_MIN = 0;
    static final int START_MAX = Integer.MAX_VALUE;
    static final String LEVEL_FILE = "currentlevel";
    static final String INITIAL_LEVEL_FILE = "initiallevel";
    Thread wc;
    long wcDelay = 2000L;
    boolean bRun = false;
    Queue<Runnable> jobQueue = new Queue(100);
    int currentLevel = 0;
    int initStartLevel = 1;
    int targetStartLevel = this.currentLevel;
    boolean acceptChanges = true;
    final FrameworkContext fwCtx;
    FileTree storage;
    final boolean bCompat;
    private final boolean readOnly;
    Object lock = new Object();
    static final Util.Comparator<BundleImpl, BundleImpl> BSComparator = new Util.Comparator<BundleImpl, BundleImpl>(){

        @Override
        public int compare(BundleImpl b1, BundleImpl b2) {
            int res = b1.getStartLevel() - b2.getStartLevel();
            if (res == 0) {
                res = (int)(b1.getBundleId() - b2.getBundleId());
            }
            return res;
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BundleImpl)x0, (BundleImpl)x1);
        }
    };

    StartLevelController(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
        this.bCompat = fwCtx.props.getBooleanProperty("org.knopflerfish.framework.startlevel.compat");
        this.readOnly = fwCtx.props.getBooleanProperty("org.knopflerfish.framework.readonly");
        this.storage = Util.getFileStorage(fwCtx, "startlevel", !this.readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("startlevel: open");
        }
        Runnable lastJob = (Runnable)this.jobQueue.lastElement();
        this.wc = new Thread(this.fwCtx.threadGroup, this, "startlevel job");
        Runnable runnable = lastJob;
        synchronized (runnable) {
            this.bRun = true;
            this.wc.start();
            if (!this.acceptChanges) {
                this.acceptChanges = true;
            }
            try {
                lastJob.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void restoreState() {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("startlevel: restoreState");
        }
        if (this.storage != null) {
            String s;
            int startLevel = -1;
            try {
                s = Util.getContent(new File(this.storage, LEVEL_FILE));
                if (s != null) {
                    startLevel = Integer.parseInt(s);
                    if (this.fwCtx.debug.startlevel) {
                        this.fwCtx.debug.println(((Object)new StringBuffer().append("startlevel: restored level ").append(startLevel)).toString());
                    }
                }
            }
            catch (Exception _ignored) {
                // empty catch block
            }
            if (startLevel == -1) {
                String sBeginningLevel = this.fwCtx.props.getProperty("org.osgi.framework.startlevel.beginning");
                try {
                    startLevel = Integer.parseInt(sBeginningLevel);
                    if (this.fwCtx.debug.startlevel) {
                        this.fwCtx.debug.println(((Object)new StringBuffer().append("startlevel: beginning level ").append(startLevel)).toString());
                    }
                }
                catch (NumberFormatException nfe) {
                    this.fwCtx.debug.printStackTrace(((Object)new StringBuffer().append("Invalid number '").append(sBeginningLevel).append("' in value of property named '").append("org.osgi.framework.startlevel.beginning").append("'.")).toString(), nfe);
                }
            }
            if (startLevel < 0) {
                startLevel = 1;
            }
            this.setStartLevel0(startLevel, false, false, true, new FrameworkListener[0]);
            try {
                s = Util.getContent(new File(this.storage, INITIAL_LEVEL_FILE));
                if (s != null) {
                    this.setInitialBundleStartLevel0(Integer.parseInt(s), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void close() {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("*** closing startlevel service");
        }
        this.bRun = false;
        this.jobQueue.insert(new Runnable(){

            public void run() {
                StartLevelController.this.jobQueue.close();
            }
        });
        if (this.wc != null) {
            try {
                this.wc.join(this.wcDelay * 2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.wc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.acceptChanges = false;
        Thread thread = this.wc;
        synchronized (thread) {
            this.setStartLevel0(0, false, true, false, new FrameworkListener[0]);
            while (this.currentLevel > 0) {
                try {
                    this.wc.wait();
                }
                catch (Exception exception) {}
            }
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.bRun) {
            try {
                Runnable job = this.jobQueue.removeWait((float)((double)this.wcDelay / 1000.0));
                if (job == null) continue;
                job.run();
                Runnable runnable = job;
                synchronized (runnable) {
                    job.notify();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    int getStartLevel() {
        return this.currentLevel;
    }

    void setStartLevel(int startLevel) {
        this.setStartLevel(startLevel, null);
    }

    void setStartLevel(int startLevel, FrameworkListener[] listeners) {
        this.fwCtx.perm.checkStartLevelAdminPerm();
        if (startLevel <= 0) {
            throw new IllegalArgumentException(((Object)new StringBuffer().append("Initial start level must be > 0, is ").append(startLevel)).toString());
        }
        if (this.acceptChanges) {
            this.setStartLevel0(startLevel, this.bRun, false, true, listeners);
        }
    }

    private void setStartLevel0(final int startLevel, final boolean notifyFw, final boolean notifyWC, final boolean storeLevel, final FrameworkListener[] listeners) {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println(((Object)new StringBuffer().append("startlevel: setStartLevel ").append(startLevel)).toString());
        }
        this.jobQueue.insert(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int sl;
                StartLevelController.this.targetStartLevel = sl = StartLevelController.this.bCompat ? 1 : startLevel;
                while (StartLevelController.this.targetStartLevel > StartLevelController.this.currentLevel) {
                    StartLevelController.this.increaseStartLevel();
                }
                while (StartLevelController.this.targetStartLevel < StartLevelController.this.currentLevel) {
                    StartLevelController.this.decreaseStartLevel();
                }
                if (storeLevel && StartLevelController.this.storage != null && !StartLevelController.this.readOnly) {
                    try {
                        Util.putContent(new File(StartLevelController.this.storage, StartLevelController.LEVEL_FILE), Integer.toString(StartLevelController.this.currentLevel));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (notifyFw) {
                    FrameworkEvent event = new FrameworkEvent(8, StartLevelController.this.fwCtx.systemBundle, null);
                    StartLevelController.this.fwCtx.listeners.frameworkEvent(event, listeners);
                }
                if (notifyWC && StartLevelController.this.wc != null) {
                    Thread thread = StartLevelController.this.wc;
                    synchronized (thread) {
                        StartLevelController.this.wc.notifyAll();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseStartLevel() {
        Object object = this.lock;
        synchronized (object) {
            ++this.currentLevel;
            if (this.fwCtx.debug.startlevel) {
                this.fwCtx.debug.println(((Object)new StringBuffer().append("startlevel: increaseStartLevel currentLevel=").append(this.currentLevel)).toString());
            }
            Vector<BundleImpl> set = new Vector<BundleImpl>();
            List<BundleImpl> bundles = this.fwCtx.bundles.getBundles();
            for (BundleImpl bs : bundles) {
                if (!this.canStart(bs) || bs.getStartLevel() != this.currentLevel || bs.current().archive.getAutostartSetting() == -1) continue;
                set.addElement(bs);
            }
            Util.sort(set, BSComparator, false);
            for (int i = 0; i < set.size(); ++i) {
                BundleImpl bs;
                bs = (BundleImpl)set.elementAt(i);
                try {
                    if (bs.current().archive.getAutostartSetting() == -1) continue;
                    if (this.fwCtx.debug.startlevel) {
                        this.fwCtx.debug.println(((Object)new StringBuffer().append("startlevel: start ").append(bs)).toString());
                    }
                    int startOptions = 1;
                    if (this.isBundleActivationPolicyUsed(bs.current().archive)) {
                        startOptions |= 2;
                    }
                    bs.start(startOptions);
                    continue;
                }
                catch (IllegalStateException ignore) {
                    continue;
                }
                catch (Exception e) {
                    this.fwCtx.frameworkError(bs, (Throwable)e, new FrameworkListener[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decreaseStartLevel() {
        Object object = this.lock;
        synchronized (object) {
            --this.currentLevel;
            Vector<BundleImpl> set = new Vector<BundleImpl>();
            List<BundleImpl> bundles = this.fwCtx.bundles.getBundles();
            for (BundleImpl bs : bundles) {
                if (bs.getState() != 32 && (bs.getState() != 8 || !bs.current().lazyActivation) || bs.getStartLevel() != this.currentLevel + 1) continue;
                set.addElement(bs);
            }
            Util.sort(set, BSComparator, true);
            Resolver resolver = this.fwCtx.resolver;
            synchronized (resolver) {
                for (int i = 0; i < set.size(); ++i) {
                    BundleImpl bs = (BundleImpl)set.elementAt(i);
                    if (bs.getState() != 32 && (bs.getState() != 8 || !bs.current().lazyActivation)) continue;
                    if (this.fwCtx.debug.startlevel) {
                        this.fwCtx.debug.println(((Object)new StringBuffer().append("startlevel: stop ").append(bs)).toString());
                    }
                    try {
                        bs.stop(1);
                        continue;
                    }
                    catch (Throwable t) {
                        this.fwCtx.frameworkError(bs, t, new FrameworkListener[0]);
                    }
                }
            }
        }
    }

    boolean canStart(BundleImpl b) {
        return b.getState() != 1;
    }

    int getBundleStartLevel(BundleImpl bundle) {
        if (bundle.getBundleId() == 0L) {
            return 0;
        }
        return bundle.getStartLevel();
    }

    void setBundleStartLevel(final BundleImpl bundle, int startLevel) {
        this.fwCtx.perm.checkExecuteAdminPerm(bundle);
        if (startLevel <= 0) {
            throw new IllegalArgumentException(((Object)new StringBuffer().append("Initial start level must be > 0, is ").append(startLevel)).toString());
        }
        if (bundle.getBundleId() == 0L) {
            throw new IllegalArgumentException("System bundle start level cannot be changed");
        }
        this.fwCtx.perm.callSetStartLevel(bundle, this.bCompat ? 1 : startLevel);
        this.jobQueue.insert(new Runnable(){

            public void run() {
                StartLevelController.this.syncStartLevel(bundle);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncStartLevel(BundleImpl bs) {
        try {
            if (this.fwCtx.debug.startlevel) {
                this.fwCtx.debug.println(((Object)new StringBuffer().append("syncstartlevel: ").append(bs)).toString());
            }
            Object object = this.lock;
            synchronized (object) {
                Resolver resolver = this.fwCtx.resolver;
                synchronized (resolver) {
                    if (bs.getStartLevel() <= this.currentLevel) {
                        BundleGeneration current = bs.current();
                        if ((bs.getState() & 0x16) != 0 && current.archive.getAutostartSetting() != -1) {
                            if (this.fwCtx.debug.startlevel) {
                                this.fwCtx.debug.println(((Object)new StringBuffer().append("startlevel: start ").append(bs)).toString());
                            }
                            int startOptions = 1;
                            if (this.isBundleActivationPolicyUsed(current.archive)) {
                                startOptions |= 2;
                            }
                            bs.start(startOptions);
                        }
                    } else if (bs.getStartLevel() > this.currentLevel && (bs.getState() & 0x28) != 0) {
                        if (this.fwCtx.debug.startlevel) {
                            this.fwCtx.debug.println(((Object)new StringBuffer().append("startlevel: stop ").append(bs)).toString());
                        }
                        bs.stop(1);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.fwCtx.frameworkError(bs, t, new FrameworkListener[0]);
        }
    }

    int getInitialBundleStartLevel() {
        return this.initStartLevel;
    }

    void setInitialBundleStartLevel(int startLevel) {
        this.fwCtx.perm.checkStartLevelAdminPerm();
        this.fwCtx.perm.callSetInitialBundleStartLevel0(this, startLevel);
    }

    void setInitialBundleStartLevel0(int startLevel, boolean save) {
        if (startLevel <= 0) {
            throw new IllegalArgumentException(((Object)new StringBuffer().append("Initial start level must be > 0, is ").append(startLevel)).toString());
        }
        int n = this.initStartLevel = this.bCompat ? 1 : startLevel;
        if (this.storage != null && !this.readOnly && save) {
            try {
                Util.putContent(new File(this.storage, INITIAL_LEVEL_FILE), Integer.toString(this.initStartLevel));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    boolean isBundlePersistentlyStarted(BundleArchive archive) {
        return archive == null || archive.getAutostartSetting() != -1;
    }

    boolean isBundleActivationPolicyUsed(BundleArchive archive) {
        return archive != null && archive.getAutostartSetting() == 2;
    }

    @Override
    public StartLevel getService(Bundle bundle, ServiceRegistration<StartLevel> registration) {
        return new StartLevelImpl(this);
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<StartLevel> registration, StartLevel service) {
    }

    BundleStartLevel bundleStartLevel(BundleImpl bi) {
        return new BundleStartLevelImpl(this, bi);
    }

    FrameworkStartLevel frameworkStartLevel(BundleImpl bi) {
        return new FrameworkStartLevelImpl(this, bi);
    }

    @Override
    public /* synthetic */ void ungetService(Bundle x0, ServiceRegistration x1, Object x2) {
        this.ungetService(x0, (ServiceRegistration<StartLevel>)x1, (StartLevel)x2);
    }

    @Override
    public /* synthetic */ Object getService(Bundle x0, ServiceRegistration x1) {
        return this.getService(x0, x1);
    }

    static class FrameworkStartLevelImpl
    implements FrameworkStartLevel {
        final StartLevelController st;
        final BundleImpl bi;

        public FrameworkStartLevelImpl(StartLevelController startLevelController, BundleImpl bi) {
            this.st = startLevelController;
            this.bi = bi;
        }

        public Bundle getBundle() {
            return this.bi;
        }

        public int getStartLevel() {
            return this.st.getStartLevel();
        }

        public void setStartLevel(int startlevel, FrameworkListener[] listeners) {
            this.st.setStartLevel(startlevel, listeners);
        }

        public int getInitialBundleStartLevel() {
            return this.st.getInitialBundleStartLevel();
        }

        public void setInitialBundleStartLevel(int startlevel) {
            this.st.setInitialBundleStartLevel(startlevel);
        }
    }

    static class BundleStartLevelImpl
    implements BundleStartLevel {
        final StartLevelController st;
        final BundleImpl bi;

        BundleStartLevelImpl(StartLevelController st, BundleImpl bi) {
            this.st = st;
            this.bi = bi;
        }

        public Bundle getBundle() {
            return this.bi;
        }

        public int getStartLevel() {
            return this.st.getBundleStartLevel(this.bi);
        }

        public void setStartLevel(int startlevel) {
            this.st.setBundleStartLevel(this.bi, startlevel);
        }

        public boolean isPersistentlyStarted() {
            return this.st.isBundlePersistentlyStarted(this.getBundleArchive());
        }

        public boolean isActivationPolicyUsed() {
            return this.st.isBundleActivationPolicyUsed(this.getBundleArchive());
        }

        private BundleArchive getBundleArchive() {
            BundleArchive res = this.bi.current().archive;
            if (res == null && this.bi.id != 0L) {
                throw new IllegalArgumentException("Bundle is in UNINSTALLED state");
            }
            return res;
        }
    }

    public static class StartLevelImpl
    implements StartLevel {
        private final StartLevelController st;

        StartLevelImpl(StartLevelController st) {
            this.st = st;
        }

        public int getBundleStartLevel(Bundle bundle) {
            return this.st.getBundleStartLevel(this.checkBundle(bundle));
        }

        public int getInitialBundleStartLevel() {
            return this.st.getInitialBundleStartLevel();
        }

        public int getStartLevel() {
            return this.st.getStartLevel();
        }

        public boolean isBundleActivationPolicyUsed(Bundle bundle) {
            return this.st.isBundleActivationPolicyUsed(this.getBundleArchive(bundle));
        }

        public boolean isBundlePersistentlyStarted(Bundle bundle) {
            return this.st.isBundlePersistentlyStarted(this.getBundleArchive(bundle));
        }

        public void setBundleStartLevel(Bundle bundle, int startlevel) {
            this.st.setBundleStartLevel(this.checkBundle(bundle), startlevel);
        }

        public void setInitialBundleStartLevel(int startlevel) {
            this.st.setInitialBundleStartLevel(startlevel);
        }

        public void setStartLevel(int startlevel) {
            this.st.setStartLevel(startlevel);
        }

        private BundleImpl checkBundle(Bundle b) {
            if (b instanceof BundleImpl) {
                BundleImpl res = (BundleImpl)b;
                if (res.fwCtx == this.st.fwCtx) {
                    if (res.state != 1) {
                        return res;
                    }
                    throw new IllegalArgumentException("Bundle is in UNINSTALLED state");
                }
            }
            throw new IllegalArgumentException("Bundle doesn't belong to the same framework as the StartLevel service");
        }

        private BundleArchive getBundleArchive(Bundle b) {
            BundleImpl bi = this.checkBundle(b);
            BundleArchive res = bi.current().archive;
            if (res == null && bi.id != 0L) {
                throw new IllegalArgumentException("Bundle is in UNINSTALLED state");
            }
            return res;
        }
    }
}

