/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleWireImpl;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleRequirementImpl
implements BundleRequirement {
    private final BundleGeneration gen;
    private final String nameSpace;
    private final Map<String, Object> attributes;
    private final Map<String, String> directives;
    private final Filter filter;
    private BundleWireImpl wire = null;
    static /* synthetic */ Class class$org$osgi$framework$wiring$BundleRequirement;

    BundleRequirementImpl(BundleGeneration gen, Util.HeaderEntry he) {
        this.gen = gen;
        this.nameSpace = he.getKey();
        for (String ns : Arrays.asList("osgi.wiring.bundle", "osgi.wiring.host", "osgi.wiring.package")) {
            if (!ns.equals(this.nameSpace)) continue;
            throw new IllegalArgumentException(((Object)new StringBuffer().append("Capability with name-space '").append(ns).append("' must not be required in the ").append("Require-Capability").append(" manifest header.")).toString());
        }
        String filterStr = he.getDirectives().remove("filter");
        if (null != filterStr && filterStr.length() > 0) {
            try {
                this.filter = FrameworkUtil.createFilter(filterStr);
                he.getDirectives().put("filter", ((Object)this.filter).toString());
            }
            catch (InvalidSyntaxException ise) {
                String msg = ((Object)new StringBuffer().append("Invalid filter '").append(filterStr).append("' in ").append("Require-Capability").append(" for name-space ").append(this.nameSpace).append(": ").append(ise)).toString();
                throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(ise);
            }
        } else {
            this.filter = null;
        }
        this.directives = Collections.unmodifiableMap(he.getDirectives());
        this.attributes = Collections.unmodifiableMap(he.getAttributes());
    }

    BundleRequirementImpl(BundleGeneration gen, String ee) {
        this.gen = gen;
        this.nameSpace = "osgi.ee";
        StringBuffer filterStrB = new StringBuffer();
        String[] l = Util.splitwords(ee, ",");
        if (l.length > 1) {
            filterStrB.append("(|");
        }
        for (String e : l) {
            String[] es = Util.splitwords(e, "-");
            try {
                if (es.length == 2) {
                    int si = es[1].indexOf(47);
                    new Version(si == -1 ? es[1] : es[1].substring(0, si));
                    filterStrB.append("(&(").append(this.nameSpace).append('=');
                    if (es[0].equalsIgnoreCase("J2SE")) {
                        es[0] = "JavaSE";
                    }
                    filterStrB.append(es[0]);
                    if (si != -1) {
                        filterStrB.append(es[1].substring(si));
                    }
                    filterStrB.append(")(version=").append(es[1]).append("))");
                    continue;
                }
                if (es.length > 2) {
                    StringBuffer esStrB = new StringBuffer(es[0]);
                    Version v = null;
                    for (int i = 1; i < es.length; ++i) {
                        if (Character.isDigit(es[i].charAt(0))) {
                            if (v == null) {
                                int si = es[i].indexOf(47);
                                v = new Version(si == -1 ? es[i] : es[i].substring(0, si));
                                if (si != -1) {
                                    esStrB.append(es[1].substring(si));
                                    continue;
                                }
                                if (i == es.length - 1) continue;
                                throw new IllegalArgumentException("Version not at end");
                            }
                            if (v.equals(new Version(es[i])) && i == es.length - 1) break;
                            throw new IllegalArgumentException("Version mismatch");
                        }
                        esStrB.append('-').append(es[i]);
                    }
                    if (v != null) {
                        filterStrB.append("(&(").append(this.nameSpace).append('=');
                        filterStrB.append(esStrB).append(")(version=");
                        filterStrB.append(v).append("))");
                        continue;
                    }
                }
            }
            catch (IllegalArgumentException _ignore) {
                // empty catch block
            }
            filterStrB.append('(').append(this.nameSpace).append('=');
            filterStrB.append(e).append(')');
        }
        if (l.length > 1) {
            filterStrB.append(')');
        }
        try {
            this.filter = FrameworkUtil.createFilter(((Object)filterStrB).toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException("Internal error");
        }
        this.directives = Collections.singletonMap("filter", ((Object)this.filter).toString());
        this.attributes = Collections.EMPTY_MAP;
    }

    @Override
    public String getNamespace() {
        return this.nameSpace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public BundleRevision getRevision() {
        return this.gen.bundleRevision;
    }

    @Override
    public BundleRevision getResource() {
        return this.gen.bundleRevision;
    }

    @Override
    public boolean matches(BundleCapability capability) {
        if (this.nameSpace.equals(capability.getNamespace())) {
            return null == this.filter ? true : this.filter.matches(capability.getAttributes());
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(40);
        sb.append("[").append((class$org$osgi$framework$wiring$BundleRequirement == null ? (class$org$osgi$framework$wiring$BundleRequirement = BundleRequirementImpl.class$("org.osgi.framework.wiring.BundleRequirement")) : class$org$osgi$framework$wiring$BundleRequirement).getName()).append(": ").append(this.nameSpace).append(" directives: ").append(this.directives.toString()).append("]");
        return ((Object)sb).toString();
    }

    BundleGeneration getBundleGeneration() {
        return this.gen;
    }

    BundleWireImpl getWire() {
        return this.wire;
    }

    void resetWire() {
        if (this.wire != null) {
            ((BundleCapabilityImpl)this.wire.getCapability()).removeWire(this.wire);
            this.wire = null;
        }
    }

    void setWire(BundleWireImpl wire) {
        ((BundleCapabilityImpl)wire.getCapability()).addWire(wire);
        this.wire = wire;
    }

    boolean isOptional() {
        String resolution = this.directives.get("resolution");
        return "optional".equals(resolution);
    }

    boolean shouldResolve() {
        String effective = this.directives.get("effective");
        return effective == null || effective.equals("resolve");
    }

    boolean isWired() {
        return this.wire != null;
    }

    @Override
    public /* synthetic */ Resource getResource() {
        return this.getResource();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

