/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class StreamReader {
    public static final String CHARENCODING = "UTF-8";
    private InputStream input;
    private State state;
    ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    OutputStream output;
    private int readGoal;
    private int readStatus;
    private int timeoutLimit = 0;
    private boolean eof = false;
    private boolean isTimeout = false;
    private int retryCounter = 0;
    private int sleepStep = 10;
    private byte[] boundary;
    private int boundaryLength;
    private int matchingBoundaryIndex;
    private byte[] matchedBoundaryBytes;
    private long bytesConsumed;
    private final State READLINE_STATE = new State(){

        @Override
        public void read(InputStream input) throws IOException {
            int b = input.read();
            if (b == -1) {
                StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                StreamReader.this.eof = true;
            } else {
                StreamReader.this.bytesConsumed++;
                if (b == 10) {
                    StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                } else if (b != 13) {
                    StreamReader.this.output.write((byte)b);
                }
            }
        }
    };
    private final State READCOUNT_STATE = new State(){

        @Override
        public void read(InputStream input) throws IOException {
            byte[] bytes = new byte[StreamReader.this.readGoal - StreamReader.this.readStatus];
            int bytesRead = input.read(bytes);
            if (bytesRead < 0) {
                StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                StreamReader.this.eof = true;
            } else {
                StreamReader.this.bytesConsumed += bytesRead;
                StreamReader.this.readStatus += bytesRead;
                StreamReader.this.output.write(bytes, 0, bytesRead);
            }
        }

        @Override
        public boolean finished() {
            return StreamReader.this.readStatus >= StreamReader.this.readGoal;
        }
    };
    private final State READUPTO_STATE = new State(){

        @Override
        public void read(InputStream input) throws IOException {
            int b = input.read();
            if (b == -1) {
                StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                StreamReader.this.eof = true;
            } else {
                StreamReader.this.bytesConsumed++;
                if (b == StreamReader.this.boundary[StreamReader.this.matchingBoundaryIndex]) {
                    ((StreamReader)StreamReader.this).matchedBoundaryBytes[((StreamReader)StreamReader.this).matchingBoundaryIndex++] = (byte)b;
                    if (StreamReader.this.matchingBoundaryIndex >= StreamReader.this.boundaryLength) {
                        StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                    }
                } else if (StreamReader.this.matchingBoundaryIndex == 0) {
                    StreamReader.this.output.write((byte)b);
                } else {
                    StreamReader.this.output.write(StreamReader.this.matchedBoundaryBytes, 0, StreamReader.this.matchingBoundaryIndex);
                    StreamReader.this.matchingBoundaryIndex = 0;
                    if (b == StreamReader.this.boundary[StreamReader.this.matchingBoundaryIndex]) {
                        ((StreamReader)StreamReader.this).matchedBoundaryBytes[((StreamReader)StreamReader.this).matchingBoundaryIndex++] = (byte)b;
                    } else {
                        StreamReader.this.output.write((byte)b);
                    }
                }
            }
        }
    };
    private final State FINAL_STATE = new State(){

        @Override
        public boolean finished() {
            return true;
        }
    };

    public StreamReader(InputStream input) {
        this.input = input;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void setTimeoutLimit(int timeout) {
        this.timeoutLimit = timeout;
    }

    public int timeoutLimit() {
        return this.timeoutLimit;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public String readLine() throws IOException {
        return this.bytesToString(this.readLineBytes());
    }

    public byte[] readLineBytes() throws IOException {
        this.state = this.READLINE_STATE;
        return this.preformRead();
    }

    public String read(int count) throws IOException {
        return this.bytesToString(this.readBytes(count));
    }

    public byte[] readBytes(int count) throws IOException {
        this.readGoal = count;
        this.readStatus = 0;
        this.state = this.READCOUNT_STATE;
        return this.preformRead();
    }

    public void copyBytes(int count, OutputStream output) throws IOException {
        this.readGoal = count;
        this.state = this.READCOUNT_STATE;
        this.performCopy(output);
    }

    public String readUpTo(String boundary) throws IOException {
        return this.bytesToString(this.readBytesUpTo(boundary));
    }

    public byte[] readBytesUpTo(String boundary) throws IOException {
        this.prepareForReadUpTo(boundary);
        return this.preformRead();
    }

    private void prepareForReadUpTo(String boundary) {
        this.boundary = boundary.getBytes();
        this.boundaryLength = this.boundary.length;
        this.matchedBoundaryBytes = new byte[this.boundaryLength];
        this.matchingBoundaryIndex = 0;
        this.state = this.READUPTO_STATE;
    }

    public void copyBytesUpTo(String boundary, OutputStream outputStream) throws IOException {
        this.prepareForReadUpTo(boundary);
        this.performCopy(outputStream);
    }

    public int byteCount() {
        return this.byteBuffer.size();
    }

    public byte[] getBufferedBytes() {
        return this.byteBuffer.toByteArray();
    }

    private byte[] preformRead() throws IOException {
        this.setReadMode();
        this.clearBuffer();
        this.readUntilFinished();
        return this.getBufferedBytes();
    }

    private void performCopy(OutputStream output) throws IOException {
        this.setCopyMode(output);
        this.readUntilFinished();
    }

    private void readUntilFinished() throws IOException {
        this.isTimeout = false;
        this.retryCounter = this.timeoutLimit > 0 ? this.timeoutLimit / this.sleepStep : 0;
        while (!this.state.finished()) {
            if (this.timeoutLimit == 0 || this.input.available() != 0) {
                this.state.read(this.input);
                continue;
            }
            try {
                Thread.sleep(this.sleepStep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.retryCounter;
            if (this.retryCounter > 0) continue;
            this.isTimeout = true;
            this.changeState(this.FINAL_STATE);
        }
    }

    private void clearBuffer() {
        this.byteBuffer.reset();
    }

    private void setCopyMode(OutputStream output) {
        this.output = output;
    }

    private void setReadMode() {
        this.output = this.byteBuffer;
    }

    private String bytesToString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, CHARENCODING);
    }

    private void changeState(State state) {
        this.state = state;
    }

    public boolean isEof() {
        return this.eof;
    }

    public long numberOfBytesConsumed() {
        return this.bytesConsumed;
    }

    public void resetNumberOfBytesConsumed() {
        this.bytesConsumed = 0L;
    }

    private static abstract class State {
        private State() {
        }

        public void read(InputStream input) throws IOException {
        }

        public boolean finished() {
            return false;
        }
    }
}

